/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.ClientAbstractSelectionHandler;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.nio.ClientPacket;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.tcp.IOSelector;
import com.hazelcast.util.Clock;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClientReadHandler
extends ClientAbstractSelectionHandler {
    private final ByteBuffer buffer;
    private volatile long lastHandle;
    private ClientPacket packet;

    public ClientReadHandler(ClientConnection connection, IOSelector ioSelector, int bufferSize) {
        super(connection, ioSelector);
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    @Override
    public void run() {
        this.registerOp(1);
    }

    public void handle() {
        this.lastHandle = Clock.currentTimeMillis();
        if (!this.connection.live()) {
            if (this.logger.isFinestEnabled()) {
                String message = "We are being asked to read, but connection is not live so we won't";
                this.logger.finest(message);
            }
            return;
        }
        try {
            int readBytes = this.socketChannel.read(this.buffer);
            if (readBytes == -1) {
                throw new EOFException("Remote socket closed!");
            }
        }
        catch (IOException e) {
            this.handleSocketException(e);
            return;
        }
        try {
            if (this.buffer.position() == 0) {
                return;
            }
            this.buffer.flip();
            this.readPacket();
            if (this.buffer.hasRemaining()) {
                this.buffer.compact();
            } else {
                this.buffer.clear();
            }
        }
        catch (Throwable t) {
            this.handleSocketException(t);
        }
    }

    private void readPacket() {
        while (this.buffer.hasRemaining()) {
            boolean complete;
            if (this.packet == null) {
                SerializationService ss = this.connection.getSerializationService();
                this.packet = new ClientPacket(ss.getPortableContext());
            }
            if (!(complete = this.packet.readFrom(this.buffer))) break;
            this.packet.setConn((Connection)this.connection);
            this.connectionManager.handlePacket(this.packet);
            this.packet = null;
        }
    }

    long getLastHandle() {
        return this.lastHandle;
    }
}

