/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.util.ExceptionUtil;

public final class ListenerUtil {
    private ListenerUtil() {
    }

    public static String listen(ClientContext context, ClientRequest request, Object key, EventHandler handler) {
        try {
            ClientInvocationServiceImpl invocationService = ListenerUtil.getClientInvocationService(context);
            ICompletableFuture future = key == null ? invocationService.invokeOnRandomTarget(request, handler) : invocationService.invokeOnKeyOwner(request, key, handler);
            String registrationId = (String)context.getSerializationService().toObject(future.get());
            invocationService.registerListener(registrationId, request.getCallId());
            return registrationId;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public static boolean stopListening(ClientContext context, BaseClientRemoveListenerRequest request, String registrationId) {
        try {
            ClientInvocationServiceImpl invocationService = ListenerUtil.getClientInvocationService(context);
            registrationId = invocationService.deRegisterListener(registrationId);
            if (registrationId == null) {
                return false;
            }
            request.setRegistrationId(registrationId);
            ICompletableFuture future = invocationService.invokeOnRandomTarget((ClientRequest)request);
            return (Boolean)context.getSerializationService().toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private static ClientInvocationServiceImpl getClientInvocationService(ClientContext context) {
        return (ClientInvocationServiceImpl)context.getInvocationService();
    }
}

