/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;

public class ClientProperties {
    public static final String PROP_CONNECTION_TIMEOUT = "hazelcast.client.connection.timeout";
    public static final String PROP_CONNECTION_TIMEOUT_DEFAULT = "5000";
    public static final String PROP_HEARTBEAT_INTERVAL = "hazelcast.client.heartbeat.interval";
    public static final String PROP_HEARTBEAT_INTERVAL_DEFAULT = "10000";
    public static final String PROP_MAX_FAILED_HEARTBEAT_COUNT = "hazelcast.client.max.failed.heartbeat.count";
    public static final String PROP_MAX_FAILED_HEARTBEAT_COUNT_DEFAULT = "3";
    public static final String PROP_RETRY_COUNT = "hazelcast.client.retry.count";
    public static final String PROP_RETRY_COUNT_DEFAULT = "20";
    public static final String PROP_RETRY_WAIT_TIME = "hazelcast.client.retry.wait.time";
    public static final String PROP_RETRY_WAIT_TIME_DEFAULT = "250";
    public final ClientProperty CONNECTION_TIMEOUT;
    public final ClientProperty HEARTBEAT_INTERVAL;
    public final ClientProperty MAX_FAILED_HEARTBEAT_COUNT;
    public final ClientProperty RETRY_COUNT;
    public final ClientProperty RETRY_WAIT_TIME;

    public ClientProperties(ClientConfig clientConfig) {
        this.CONNECTION_TIMEOUT = new ClientProperty(clientConfig, PROP_CONNECTION_TIMEOUT, PROP_CONNECTION_TIMEOUT_DEFAULT);
        this.HEARTBEAT_INTERVAL = new ClientProperty(clientConfig, PROP_HEARTBEAT_INTERVAL, PROP_HEARTBEAT_INTERVAL_DEFAULT);
        this.MAX_FAILED_HEARTBEAT_COUNT = new ClientProperty(clientConfig, PROP_MAX_FAILED_HEARTBEAT_COUNT, PROP_MAX_FAILED_HEARTBEAT_COUNT_DEFAULT);
        this.RETRY_COUNT = new ClientProperty(clientConfig, PROP_RETRY_COUNT, PROP_RETRY_COUNT_DEFAULT);
        this.RETRY_WAIT_TIME = new ClientProperty(clientConfig, PROP_RETRY_WAIT_TIME, PROP_RETRY_WAIT_TIME_DEFAULT);
    }

    public static class ClientProperty {
        private final String name;
        private final String value;

        ClientProperty(ClientConfig config, String name) {
            this(config, name, (String)null);
        }

        ClientProperty(ClientConfig config, String name, ClientProperty defaultValue) {
            this(config, name, defaultValue != null ? defaultValue.getString() : null);
        }

        ClientProperty(ClientConfig config, String name, String defaultValue) {
            String configValue;
            this.name = name;
            String string = configValue = config != null ? config.getProperty(name) : null;
            this.value = configValue != null ? configValue : (System.getProperty(name) != null ? System.getProperty(name) : defaultValue);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getInteger() {
            return Integer.parseInt(this.value);
        }

        public byte getByte() {
            return Byte.parseByte(this.value);
        }

        public boolean getBoolean() {
            return Boolean.valueOf(this.value);
        }

        public String getString() {
            return this.value;
        }

        public long getLong() {
            return Long.parseLong(this.value);
        }

        public String toString() {
            return "ClientProperty [name=" + this.name + ", value=" + this.value + "]";
        }
    }
}

