/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.atomicreference.client.AlterAndGetRequest;
import com.hazelcast.concurrent.atomicreference.client.AlterRequest;
import com.hazelcast.concurrent.atomicreference.client.ApplyRequest;
import com.hazelcast.concurrent.atomicreference.client.CompareAndSetRequest;
import com.hazelcast.concurrent.atomicreference.client.ContainsRequest;
import com.hazelcast.concurrent.atomicreference.client.GetAndAlterRequest;
import com.hazelcast.concurrent.atomicreference.client.GetAndSetRequest;
import com.hazelcast.concurrent.atomicreference.client.GetRequest;
import com.hazelcast.concurrent.atomicreference.client.IsNullRequest;
import com.hazelcast.concurrent.atomicreference.client.SetRequest;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IFunction;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ValidationUtil;

public class ClientAtomicReferenceProxy<E>
extends ClientProxy
implements IAtomicReference<E> {
    private final String name;
    private volatile Data key;

    public ClientAtomicReferenceProxy(String instanceName, String serviceName, String objectId) {
        super(instanceName, serviceName, objectId);
        this.name = objectId;
    }

    public <R> R apply(IFunction<E, R> function) {
        ValidationUtil.isNotNull(function, (String)"function");
        return (R)this.invoke((ClientRequest)new ApplyRequest(this.name, this.toData(function)));
    }

    public void alter(IFunction<E, E> function) {
        ValidationUtil.isNotNull(function, (String)"function");
        this.invoke((ClientRequest)new AlterRequest(this.name, this.toData(function)));
    }

    public E alterAndGet(IFunction<E, E> function) {
        ValidationUtil.isNotNull(function, (String)"function");
        return (E)this.invoke((ClientRequest)new AlterAndGetRequest(this.name, this.toData(function)));
    }

    public E getAndAlter(IFunction<E, E> function) {
        ValidationUtil.isNotNull(function, (String)"function");
        return (E)this.invoke((ClientRequest)new GetAndAlterRequest(this.name, this.toData(function)));
    }

    public boolean compareAndSet(E expect, E update) {
        return (Boolean)this.invoke((ClientRequest)new CompareAndSetRequest(this.name, this.toData(expect), this.toData(update)));
    }

    public boolean contains(E expected) {
        return (Boolean)this.invoke((ClientRequest)new ContainsRequest(this.name, this.toData(expected)));
    }

    public E get() {
        return (E)this.invoke((ClientRequest)new GetRequest(this.name));
    }

    public void set(E newValue) {
        this.invoke((ClientRequest)new SetRequest(this.name, this.toData(newValue)));
    }

    public void clear() {
        this.set(null);
    }

    public E getAndSet(E newValue) {
        return (E)this.invoke((ClientRequest)new GetAndSetRequest(this.name, this.toData(newValue)));
    }

    public E setAndGet(E update) {
        this.invoke((ClientRequest)new SetRequest(this.name, this.toData(update)));
        return update;
    }

    public boolean isNull() {
        return (Boolean)this.invoke((ClientRequest)new IsNullRequest(this.name));
    }

    @Override
    protected void onDestroy() {
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.getKey());
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.name);
        }
        return this.key;
    }

    public String toString() {
        return "IAtomicReference{name='" + this.name + '\'' + '}';
    }
}

