/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.nearcache;

import com.hazelcast.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.nearcache.ClientNearCacheType;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.util.ListenerUtil;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.client.MapAddEntryListenerRequest;
import com.hazelcast.map.client.MapRemoveEntryListenerRequest;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientNearCache<K> {
    static final int evictionPercentage = 20;
    static final int cleanupInterval = 5000;
    final ClientNearCacheType cacheType;
    final int maxSize;
    volatile long lastCleanup;
    final long maxIdleMillis;
    final long timeToLiveMillis;
    final boolean invalidateOnChange;
    final EvictionPolicy evictionPolicy;
    final InMemoryFormat inMemoryFormat;
    final String mapName;
    final ClientContext context;
    final AtomicBoolean canCleanUp;
    final AtomicBoolean canEvict;
    final ConcurrentMap<K, CacheRecord<K>> cache;
    public static final Object NULL_OBJECT = new Object();
    String registrationId = null;
    final NearCacheStatsImpl stats;
    private final Comparator<CacheRecord<K>> comparator = new Comparator<CacheRecord<K>>(){

        @Override
        public int compare(CacheRecord<K> o1, CacheRecord<K> o2) {
            if (EvictionPolicy.LRU.equals((Object)ClientNearCache.this.evictionPolicy)) {
                return Long.valueOf(o1.lastAccessTime).compareTo(o2.lastAccessTime);
            }
            if (EvictionPolicy.LFU.equals((Object)ClientNearCache.this.evictionPolicy)) {
                return Integer.valueOf(o1.hit.get()).compareTo(o2.hit.get());
            }
            return 0;
        }
    };

    public ClientNearCache(String mapName, ClientNearCacheType cacheType, ClientContext context, NearCacheConfig nearCacheConfig) {
        this.mapName = mapName;
        this.cacheType = cacheType;
        this.context = context;
        this.maxSize = nearCacheConfig.getMaxSize();
        this.maxIdleMillis = nearCacheConfig.getMaxIdleSeconds() * 1000;
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        this.timeToLiveMillis = nearCacheConfig.getTimeToLiveSeconds() * 1000;
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.evictionPolicy = EvictionPolicy.valueOf(nearCacheConfig.getEvictionPolicy());
        this.cache = new ConcurrentHashMap<K, CacheRecord<K>>();
        this.canCleanUp = new AtomicBoolean(true);
        this.canEvict = new AtomicBoolean(true);
        this.lastCleanup = Clock.currentTimeMillis();
        this.stats = new NearCacheStatsImpl();
        if (this.invalidateOnChange) {
            this.addInvalidateListener();
        }
    }

    private void addInvalidateListener() {
        try {
            if (this.cacheType != ClientNearCacheType.Map) {
                throw new IllegalStateException("Near cache is not available for this type of data structure");
            }
            MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.mapName, false);
            EventHandler<PortableEntryEvent> handler = new EventHandler<PortableEntryEvent>(){

                @Override
                public void handle(PortableEntryEvent event) {
                    ClientNearCache.this.cache.remove(event.getKey());
                }
            };
            this.registrationId = ListenerUtil.listen(this.context, (ClientRequest)request, null, handler);
        }
        catch (Exception e) {
            Logger.getLogger(ClientNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", (Throwable)e);
        }
    }

    public void put(K key, Object object) {
        this.fireTtlCleanup();
        if (this.evictionPolicy == EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            return;
        }
        if (this.evictionPolicy != EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            this.fireEvictCache();
        }
        Object value = object == null ? NULL_OBJECT : (this.inMemoryFormat.equals((Object)InMemoryFormat.BINARY) ? this.context.getSerializationService().toData(object) : object);
        this.cache.put(key, new CacheRecord<K>(key, value));
    }

    private void fireEvictCache() {
        if (this.canEvict.compareAndSet(true, false)) {
            try {
                this.context.getExecutionService().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TreeSet records = new TreeSet(ClientNearCache.this.comparator);
                            records.addAll(ClientNearCache.this.cache.values());
                            int evictSize = ClientNearCache.this.cache.size() * 20 / 100;
                            int i = 0;
                            for (CacheRecord record : records) {
                                ClientNearCache.this.cache.remove(record.key);
                                if (++i <= evictSize) continue;
                                break;
                            }
                        }
                        finally {
                            ClientNearCache.this.canEvict.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canEvict.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    private void fireTtlCleanup() {
        if (Clock.currentTimeMillis() < this.lastCleanup + 5000L) {
            return;
        }
        if (this.canCleanUp.compareAndSet(true, false)) {
            try {
                this.context.getExecutionService().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ClientNearCache.this.lastCleanup = Clock.currentTimeMillis();
                            for (Map.Entry entry : ClientNearCache.this.cache.entrySet()) {
                                if (!((CacheRecord)entry.getValue()).expired()) continue;
                                ClientNearCache.this.cache.remove(entry.getKey());
                            }
                        }
                        finally {
                            ClientNearCache.this.canCleanUp.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canCleanUp.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    public Object get(K key) {
        this.fireTtlCleanup();
        CacheRecord record = (CacheRecord)this.cache.get(key);
        if (record != null) {
            record.access();
            if (record.expired()) {
                this.cache.remove(key);
                this.stats.incrementMisses();
                return null;
            }
            if (record.value.equals(NULL_OBJECT)) {
                this.stats.incrementMisses();
                return NULL_OBJECT;
            }
            return this.inMemoryFormat.equals((Object)InMemoryFormat.BINARY) ? this.context.getSerializationService().toObject((Object)((Data)record.value)) : record.value;
        }
        this.stats.incrementMisses();
        return null;
    }

    public NearCacheStatsImpl getNearCacheStats() {
        return this.createNearCacheStats();
    }

    private NearCacheStatsImpl createNearCacheStats() {
        long ownedEntryCount = 0L;
        long ownedEntryMemory = 0L;
        long hits = 0L;
        for (CacheRecord record : this.cache.values()) {
            ++ownedEntryCount;
            ownedEntryMemory += record.getCost();
            hits += (long)record.hit.get();
        }
        this.stats.setOwnedEntryCount(ownedEntryCount);
        this.stats.setOwnedEntryMemoryCost(ownedEntryMemory);
        this.stats.setHits(hits);
        return this.stats;
    }

    public void destroy() {
        if (this.registrationId != null) {
            if (this.cacheType != ClientNearCacheType.Map) {
                throw new IllegalStateException("Near cache is not available for this type of data structure");
            }
            MapRemoveEntryListenerRequest request = new MapRemoveEntryListenerRequest(this.mapName, this.registrationId);
            ListenerUtil.stopListening(this.context, (BaseClientRemoveListenerRequest)request, this.registrationId);
        }
        this.cache.clear();
    }

    class CacheRecord<K> {
        final K key;
        final Object value;
        volatile long lastAccessTime;
        final long creationTime;
        final AtomicInteger hit;

        CacheRecord(K key, Object value) {
            long time;
            this.key = key;
            this.value = value;
            this.lastAccessTime = time = Clock.currentTimeMillis();
            this.creationTime = time;
            this.hit = new AtomicInteger(0);
        }

        void access() {
            this.hit.incrementAndGet();
            this.lastAccessTime = Clock.currentTimeMillis();
        }

        public long getCost() {
            if (!(this.value instanceof Data)) {
                return 0L;
            }
            if (!(this.key instanceof Data)) {
                return 0L;
            }
            return ((Data)this.key).getHeapCost() + ((Data)this.value).getHeapCost() + 16 + 4 + 12;
        }

        boolean expired() {
            long time = Clock.currentTimeMillis();
            return ClientNearCache.this.maxIdleMillis > 0L && time > this.lastAccessTime + ClientNearCache.this.maxIdleMillis || ClientNearCache.this.timeToLiveMillis > 0L && time > this.creationTime + ClientNearCache.this.timeToLiveMillis;
        }
    }

    static enum EvictionPolicy {
        NONE,
        LRU,
        LFU;

    }
}

