/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.Addresses;
import com.hazelcast.client.spi.impl.discovery.HazelcastCloudDiscovery;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;

public class HazelcastCloudAddressProvider
implements AddressProvider {
    private final ILogger logger;
    private final HazelcastCloudDiscovery cloudDiscovery;

    public HazelcastCloudAddressProvider(String endpointUrl, int connectionTimeoutInMillis, LoggingService loggingService) {
        this(new HazelcastCloudDiscovery(endpointUrl, connectionTimeoutInMillis), loggingService);
    }

    HazelcastCloudAddressProvider(HazelcastCloudDiscovery cloudDiscovery, LoggingService loggingService) {
        this.cloudDiscovery = cloudDiscovery;
        this.logger = loggingService.getLogger(HazelcastCloudAddressProvider.class);
    }

    @Override
    public Addresses loadAddresses() {
        try {
            return new Addresses(this.cloudDiscovery.discoverNodes().keySet());
        }
        catch (Exception e) {
            this.logger.warning("Failed to load addresses from hazelcast.cloud : " + e.getMessage());
            return new Addresses();
        }
    }
}

