/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.util.ExceptionUtil;
import java.util.Properties;

public class DefaultCredentialsFactory
implements ICredentialsFactory {
    private final Credentials credentials;

    public DefaultCredentialsFactory(ClientSecurityConfig securityConfig, GroupConfig groupConfig, ClassLoader classLoader) {
        this.credentials = this.initCredentials(securityConfig, groupConfig, classLoader);
    }

    private Credentials initCredentials(ClientSecurityConfig securityConfig, GroupConfig groupConfig, ClassLoader classLoader) {
        String credentialsClassname;
        Credentials credentials = securityConfig.getCredentials();
        if (credentials == null && (credentialsClassname = securityConfig.getCredentialsClassname()) != null) {
            try {
                credentials = (Credentials)ClassLoaderUtil.newInstance((ClassLoader)classLoader, (String)credentialsClassname);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        if (credentials == null) {
            credentials = new UsernamePasswordCredentials(groupConfig.getName(), groupConfig.getPassword());
        }
        return credentials;
    }

    public void configure(GroupConfig groupConfig, Properties properties) {
    }

    public Credentials newCredentials() {
        return this.credentials;
    }

    public void destroy() {
    }
}

