/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.atomiclong;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongAddAndGetCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongAlterCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongApplyCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongGetAndAddCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongGetAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicLongGetCodec;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IFunction;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.atomiclong.operation.AlterOp;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;

class RaftAtomicLongProxy
extends ClientProxy
implements IAtomicLong {
    private static final ClientMessageDecoder ADD_AND_GET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongAddAndGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder COMPARE_AND_SET_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongCompareAndSetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_ADD_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongGetAndAddCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_AND_SET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongGetAndSetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder APPLY_DECODER = new ClientMessageDecoder(){

        public Object decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongApplyCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder ALTER_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicLongAlterCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private final RaftGroupId groupId;
    private final String objectName;

    RaftAtomicLongProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:atomicLongService", proxyName, context);
        this.groupId = groupId;
        this.objectName = objectName;
    }

    public long addAndGet(long delta) {
        return (Long)this.addAndGetAsync(delta).join();
    }

    public boolean compareAndSet(long expect, long update) {
        return (Boolean)this.compareAndSetAsync(expect, update).join();
    }

    public long decrementAndGet() {
        return (Long)this.decrementAndGetAsync().join();
    }

    public long get() {
        return (Long)this.getAsync().join();
    }

    public long getAndAdd(long delta) {
        return (Long)this.getAndAddAsync(delta).join();
    }

    public long getAndSet(long newValue) {
        return (Long)this.getAndSetAsync(newValue).join();
    }

    public long incrementAndGet() {
        return (Long)this.incrementAndGetAsync().join();
    }

    public long getAndIncrement() {
        return (Long)this.getAndIncrementAsync().join();
    }

    public void set(long newValue) {
        this.setAsync(newValue).join();
    }

    public void alter(IFunction<Long, Long> function) {
        this.alterAsync(function).join();
    }

    public long alterAndGet(IFunction<Long, Long> function) {
        return (Long)this.alterAndGetAsync(function).join();
    }

    public long getAndAlter(IFunction<Long, Long> function) {
        return (Long)this.getAndAlterAsync(function).join();
    }

    public <R> R apply(IFunction<Long, R> function) {
        return (R)this.applyAsync(function).join();
    }

    public InternalCompletableFuture<Long> addAndGetAsync(long delta) {
        ClientMessage request = CPAtomicLongAddAndGetCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)delta);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), ADD_AND_GET_DECODER);
    }

    public InternalCompletableFuture<Boolean> compareAndSetAsync(long expect, long update) {
        ClientMessage request = CPAtomicLongCompareAndSetCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)expect, (long)update);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Boolean>(future, this.getSerializationService(), COMPARE_AND_SET_DECODER);
    }

    public InternalCompletableFuture<Long> decrementAndGetAsync() {
        return this.addAndGetAsync(-1L);
    }

    public InternalCompletableFuture<Long> getAsync() {
        ClientMessage request = CPAtomicLongGetCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), GET_DECODER);
    }

    public InternalCompletableFuture<Long> getAndAddAsync(long delta) {
        ClientMessage request = CPAtomicLongGetAndAddCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)delta);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), GET_AND_ADD_DECODER);
    }

    public InternalCompletableFuture<Long> getAndSetAsync(long newValue) {
        ClientMessage request = CPAtomicLongGetAndSetCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (long)newValue);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), GET_AND_SET_DECODER);
    }

    public InternalCompletableFuture<Long> incrementAndGetAsync() {
        return this.addAndGetAsync(1L);
    }

    public InternalCompletableFuture<Long> getAndIncrementAsync() {
        return this.getAndAddAsync(1L);
    }

    public InternalCompletableFuture<Void> setAsync(long newValue) {
        InternalCompletableFuture<Long> future = this.getAndSetAsync(newValue);
        return future;
    }

    public InternalCompletableFuture<Void> alterAsync(IFunction<Long, Long> function) {
        InternalCompletableFuture<Long> future = this.alterAndGetAsync(function);
        return future;
    }

    public InternalCompletableFuture<Long> alterAndGetAsync(IFunction<Long, Long> function) {
        Data f = this.getSerializationService().toData(function);
        ClientMessage request = CPAtomicLongAlterCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (Data)f, (int)AlterOp.AlterResultType.NEW_VALUE.value());
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), ALTER_DECODER);
    }

    public InternalCompletableFuture<Long> getAndAlterAsync(IFunction<Long, Long> function) {
        Data f = this.getSerializationService().toData(function);
        ClientMessage request = CPAtomicLongAlterCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (Data)f, (int)AlterOp.AlterResultType.OLD_VALUE.value());
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Long>(future, this.getSerializationService(), ALTER_DECODER);
    }

    public <R> InternalCompletableFuture<R> applyAsync(IFunction<Long, R> function) {
        Data f = this.getSerializationService().toData(function);
        ClientMessage request = CPAtomicLongApplyCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (Data)f);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), APPLY_DECODER);
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.getServiceName(), (String)this.objectName);
        new ClientInvocation(this.getClient(), request, this.name).invoke().join();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }
}

