/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.client.cache.impl.ClientCacheHelper;
import com.hazelcast.client.cache.impl.ClientCacheProxy;
import com.hazelcast.client.cache.impl.NearCachedClientCacheProxy;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientProxyFactoryWithContext;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.NearCacheConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientCacheProxyFactory
extends ClientProxyFactoryWithContext {
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentMap<String, CacheConfig> configs = new ConcurrentHashMap<String, CacheConfig>();

    public ClientCacheProxyFactory(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    public ClientProxy create(String id, ClientContext context) {
        CacheConfig cacheConfig = this.findCacheConfig(id);
        if (cacheConfig == null) {
            throw new CacheNotExistsException("Cache " + id + " is already destroyed or not created yet");
        }
        NearCacheConfig nearCacheConfig = this.client.getClientConfig().getNearCacheConfig(cacheConfig.getName());
        if (nearCacheConfig != null) {
            return new NearCachedClientCacheProxy(cacheConfig, context);
        }
        return new ClientCacheProxy(cacheConfig, context);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"})
    void addCacheConfig(String cacheName, CacheConfig cacheConfig) {
        this.configs.putIfAbsent(cacheName, cacheConfig);
    }

    void removeCacheConfig(String cacheName) {
        this.configs.remove(cacheName);
    }

    CacheConfig getCacheConfig(String cacheName) {
        return (CacheConfig)this.configs.get(cacheName);
    }

    Set<Map.Entry<String, CacheConfig>> configs() {
        return this.configs.entrySet();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"})
    private CacheConfig findCacheConfig(String cacheName) {
        CacheConfig cacheConfig = (CacheConfig)this.configs.get(cacheName);
        if (cacheConfig != null) {
            return cacheConfig;
        }
        String simpleCacheName = cacheName.substring("/hz/".length());
        cacheConfig = ClientCacheHelper.getCacheConfig(this.client, cacheName, simpleCacheName);
        if (cacheConfig != null) {
            this.configs.putIfAbsent(cacheName, cacheConfig);
        }
        return cacheConfig;
    }
}

