/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheEventType;
import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheEntryProcessorResult;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.event.CachePartitionLostEvent;
import com.hazelcast.cache.impl.event.CachePartitionLostListener;
import com.hazelcast.cache.journal.EventJournalCacheEvent;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxy;
import com.hazelcast.client.cache.impl.ClientCachePartitionIterator;
import com.hazelcast.client.cache.impl.ClientClusterWideIterator;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.CacheEntryProcessorCodec;
import com.hazelcast.client.impl.protocol.codec.CacheEventJournalReadCodec;
import com.hazelcast.client.impl.protocol.codec.CacheEventJournalSubscribeCodec;
import com.hazelcast.client.impl.protocol.codec.CacheListenerRegistrationCodec;
import com.hazelcast.client.impl.protocol.codec.CacheLoadAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.CacheRemovePartitionLostListenerCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.internal.journal.EventJournalInitialSubscriberState;
import com.hazelcast.internal.journal.EventJournalReader;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.projection.Projection;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.impl.client.PortableReadResultSet;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.function.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class ClientCacheProxy<K, V>
extends AbstractClientCacheProxy<K, V>
implements EventJournalReader<EventJournalCacheEvent<K, V>> {
    private ClientMessageDecoder eventJournalReadResponseDecoder;
    private ClientMessageDecoder eventJournalSubscribeResponseDecoder;

    ClientCacheProxy(CacheConfig<K, V> cacheConfig, ClientContext context) {
        super(cacheConfig, context);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.eventJournalReadResponseDecoder = new ClientMessageDecoder(){

            public ReadResultSet<?> decodeClientMessage(ClientMessage message) {
                CacheEventJournalReadCodec.ResponseParameters params = CacheEventJournalReadCodec.decodeResponse((ClientMessage)message);
                PortableReadResultSet resultSet = new PortableReadResultSet(params.readCount, params.items, params.itemSeqs, params.nextSeqExist ? params.nextSeq : -1L);
                resultSet.setSerializationService(ClientCacheProxy.this.getSerializationService());
                return resultSet;
            }
        };
        this.eventJournalSubscribeResponseDecoder = new ClientMessageDecoder(){

            public EventJournalInitialSubscriberState decodeClientMessage(ClientMessage message) {
                CacheEventJournalSubscribeCodec.ResponseParameters resp = CacheEventJournalSubscribeCodec.decodeResponse((ClientMessage)message);
                return new EventJournalInitialSubscriberState(resp.oldestSequence, resp.newestSequence);
            }
        };
    }

    public V get(K key) {
        return (V)this.get((Object)key, (ExpiryPolicy)null);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.getAll((Set)keys, (ExpiryPolicy)null);
    }

    public boolean containsKey(K key) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        return this.containsKeyInternal(key);
    }

    protected boolean containsKeyInternal(Object key) {
        Data keyData = this.toData(key);
        ClientMessage request = CacheContainsKeyCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData);
        ClientMessage result = this.invoke(request, keyData);
        return CacheContainsKeyCodec.decodeResponse((ClientMessage)result).response;
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys.size());
        for (K key : keys) {
            CacheProxyUtil.validateNotNull(key);
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
            dataKeys.add(this.toData(key));
        }
        this.loadAllInternal(keys, dataKeys, replaceExistingValues, completionListener);
    }

    protected void loadAllInternal(Set<? extends K> keys, List<Data> dataKeys, boolean replaceExistingValues, CompletionListener completionListener) {
        ClientMessage request = CacheLoadAllCodec.encodeRequest((String)this.nameWithPrefix, dataKeys, (boolean)replaceExistingValues);
        try {
            this.submitLoadAllTask(request, completionListener, dataKeys);
        }
        catch (Exception e) {
            if (completionListener != null) {
                completionListener.onException(e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    protected void onLoadAll(List<Data> keys, Object response, long startNanos) {
        if (this.statisticsEnabled) {
            this.statsHandler.onBatchPut(startNanos, keys.size());
        }
    }

    public void put(K key, V value) {
        this.put((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public V getAndPut(K key, V value) {
        return (V)this.getAndPut((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll((Map)map, (ExpiryPolicy)null);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public boolean remove(K key) {
        long start = this.nowInNanosOrDefault();
        try {
            boolean removed = (Boolean)this.removeAsyncInternal(key, null, false, true, false);
            if (this.statisticsEnabled) {
                this.statsHandler.onRemove(false, start, removed);
            }
            return removed;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public boolean remove(K key, V oldValue) {
        long start = this.nowInNanosOrDefault();
        try {
            boolean removed = (Boolean)this.removeAsyncInternal(key, oldValue, true, true, false);
            if (this.statisticsEnabled) {
                this.statsHandler.onRemove(false, start, removed);
            }
            return removed;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public V getAndRemove(K key) {
        long start = this.nowInNanosOrDefault();
        ClientDelegatingFuture future = this.getAndRemoveSyncInternal(key);
        try {
            Object removedValue = this.toObject(future.get());
            if (this.statisticsEnabled) {
                this.statsHandler.onRemove(true, start, removedValue);
            }
            return (V)removedValue;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace((Object)key, (Object)oldValue, (Object)newValue, (ExpiryPolicy)null);
    }

    public boolean replace(K key, V value) {
        return this.replace((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public V getAndReplace(K key, V value) {
        return (V)this.getAndReplace((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void removeAll(Set<? extends K> keys) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        Preconditions.checkNotNull(keys, (String)"Null key is not allowed!");
        if (keys.isEmpty()) {
            return;
        }
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys.size());
        CollectionUtil.objectToDataCollection(keys, dataKeys, (SerializationService)this.getSerializationService(), (String)"Null key is not allowed!");
        this.removeAllKeysInternal(keys, dataKeys, startNanos);
    }

    public void removeAll() {
        this.ensureOpen();
        this.removeAllInternal();
    }

    public void clear() {
        this.ensureOpen();
        this.clearInternal();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.cacheConfig)) {
            return (C)((Configuration)clazz.cast(this.cacheConfig.getAsReadOnly()));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        Data epData = this.toData(entryProcessor);
        return (T)this.invokeInternal(key, epData, arguments);
    }

    protected Object invokeInternal(Object key, Data epData, Object ... arguments) {
        List argumentsData;
        Data keyData = this.toData(key);
        if (arguments != null) {
            argumentsData = new ArrayList(arguments.length);
            for (int i = 0; i < arguments.length; ++i) {
                argumentsData.add(this.toData(arguments[i]));
            }
        } else {
            argumentsData = Collections.emptyList();
        }
        int completionId = this.nextCompletionId();
        ClientMessage request = CacheEntryProcessorCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)epData, argumentsData, (int)completionId);
        try {
            ClientInvocationFuture future = this.invoke(request, keyData, completionId);
            ClientMessage response = (ClientMessage)this.getSafely(future);
            Data data = CacheEntryProcessorCodec.decodeResponse((ClientMessage)response).response;
            return this.toObject(data);
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new EntryProcessorException((Throwable)e);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        Map allResult = MapUtil.createHashMap((int)keys.size());
        for (K key : keys) {
            CacheEntryProcessorResult cepResult;
            CacheProxyUtil.validateNotNull(key);
            try {
                T result = this.invoke(key, entryProcessor, arguments);
                cepResult = result != null ? new CacheEntryProcessorResult(result) : null;
            }
            catch (Exception e) {
                cepResult = new CacheEntryProcessorResult((Throwable)e);
            }
            if (cepResult == null) continue;
            allResult.put(key, cepResult);
        }
        return allResult;
    }

    public CacheManager getCacheManager() {
        return (CacheManager)this.cacheManagerRef.get();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.registerCacheEntryListener(cacheEntryListenerConfiguration, true);
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean addToConfig) {
        this.ensureOpen();
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        CacheEventListenerAdaptor adaptor = new CacheEventListenerAdaptor((ICache)this, cacheEntryListenerConfiguration, this.getSerializationService());
        EventHandler handler = this.createHandler(adaptor);
        String regId = this.getContext().getListenerService().registerListener(this.createCacheEntryListenerCodec(), handler);
        if (regId != null) {
            if (addToConfig) {
                this.cacheConfig.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            }
            this.addListenerLocally(regId, cacheEntryListenerConfiguration, adaptor);
            if (addToConfig) {
                this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, true);
            }
        }
    }

    private ListenerMessageCodec createCacheEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return CacheAddEntryListenerCodec.encodeRequest((String)ClientCacheProxy.this.nameWithPrefix, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return CacheAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemoveEntryListenerCodec.encodeRequest((String)ClientCacheProxy.this.nameWithPrefix, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        String regId = this.getListenerIdLocal(cacheEntryListenerConfiguration);
        if (regId == null) {
            return;
        }
        boolean isDeregistered = this.getContext().getListenerService().deregisterListener(regId);
        if (isDeregistered) {
            this.removeListenerLocally(cacheEntryListenerConfiguration);
            this.cacheConfig.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, false);
        }
    }

    protected void updateCacheListenerConfigOnOtherNodes(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean isRegister) {
        Collection<Member> members = this.getContext().getClusterService().getMemberList();
        for (Member member : members) {
            try {
                Address address = member.getAddress();
                Data configData = this.toData(cacheEntryListenerConfiguration);
                ClientMessage request = CacheListenerRegistrationCodec.encodeRequest((String)this.nameWithPrefix, (Data)configData, (boolean)isRegister, (Address)address);
                ClientInvocation invocation = new ClientInvocation(this.getClient(), request, this.getName(), address);
                invocation.invoke();
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow((Throwable)e);
            }
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new ClientClusterWideIterator(this, this.getContext(), false);
    }

    public Iterator<Cache.Entry<K, V>> iterator(int fetchSize) {
        this.ensureOpen();
        return new ClientClusterWideIterator(this, this.getContext(), fetchSize, false);
    }

    public Iterator<Cache.Entry<K, V>> iterator(int fetchSize, int partitionId, boolean prefetchValues) {
        this.ensureOpen();
        return new ClientCachePartitionIterator(this, this.getContext(), fetchSize, partitionId, prefetchValues);
    }

    public void setExpiryPolicy(K key, ExpiryPolicy expiryPolicy) {
        this.setExpiryPolicy(Collections.singleton(key), expiryPolicy);
    }

    public String addPartitionLostListener(CachePartitionLostListener listener) {
        ClientCachePartitionLostEventHandler handler = new ClientCachePartitionLostEventHandler(listener);
        this.injectDependencies(listener);
        return this.getContext().getListenerService().registerListener(this.createPartitionLostListenerCodec(), handler);
    }

    private ListenerMessageCodec createPartitionLostListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return CacheAddPartitionLostListenerCodec.encodeRequest((String)ClientCacheProxy.this.name, (boolean)localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return CacheAddPartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return CacheRemovePartitionLostListenerCodec.encodeRequest((String)ClientCacheProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return CacheRemovePartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    public boolean removePartitionLostListener(String id) {
        return this.getContext().getListenerService().deregisterListener(id);
    }

    public ICompletableFuture<EventJournalInitialSubscriberState> subscribeToEventJournal(int partitionId) {
        ClientMessage request = CacheEventJournalSubscribeCodec.encodeRequest((String)this.nameWithPrefix);
        ClientInvocationFuture fut = new ClientInvocation(this.getClient(), request, this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture(fut, this.getSerializationService(), this.eventJournalSubscribeResponseDecoder);
    }

    public <T> ICompletableFuture<ReadResultSet<T>> readFromEventJournal(long startSequence, int minSize, int maxSize, int partitionId, Predicate<? super EventJournalCacheEvent<K, V>> predicate, Projection<? super EventJournalCacheEvent<K, V>, ? extends T> projection) {
        if (maxSize < minSize) {
            throw new IllegalArgumentException("maxSize " + maxSize + " must be greater or equal to minSize " + minSize);
        }
        SerializationService ss = this.getSerializationService();
        ClientMessage request = CacheEventJournalReadCodec.encodeRequest((String)this.nameWithPrefix, (long)startSequence, (int)minSize, (int)maxSize, (Data)ss.toData(predicate), (Data)ss.toData(projection));
        ClientInvocationFuture fut = new ClientInvocation(this.getClient(), request, this.getName(), partitionId).invoke();
        return new ClientDelegatingFuture(fut, ss, this.eventJournalReadResponseDecoder);
    }

    private final class ClientCachePartitionLostEventHandler
    extends CacheAddPartitionLostListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private CachePartitionLostListener listener;

        private ClientCachePartitionLostEventHandler(CachePartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }

        public void handleCachePartitionLostEventV10(int partitionId, String uuid) {
            Member member = ClientCacheProxy.this.getContext().getClusterService().getMember(uuid);
            this.listener.partitionLost(new CachePartitionLostEvent((Object)ClientCacheProxy.this.name, member, CacheEventType.PARTITION_LOST.getType(), partitionId));
        }
    }
}

