/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.util.ClientMessageEncoder;
import com.hazelcast.client.impl.protocol.util.ClientMessageHandler;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelInboundHandler;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.ChannelOutboundHandler;
import com.hazelcast.internal.networking.InitResult;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.StringUtil;
import java.nio.ByteBuffer;

class ClientChannelInitializer
implements ChannelInitializer {
    private final int bufferSize;
    private final boolean direct;

    ClientChannelInitializer(int bufferSize, boolean direct) {
        this.bufferSize = bufferSize;
        this.direct = direct;
    }

    public InitResult<ChannelInboundHandler> initInbound(Channel channel) {
        ByteBuffer inputBuffer = IOUtil.newByteBuffer((int)this.bufferSize, (boolean)this.direct);
        final ClientConnection clientConnection = (ClientConnection)channel.attributeMap().get(ClientConnection.class);
        ClientMessageDecoder inboundHandler = new ClientMessageDecoder((Connection)clientConnection, new ClientMessageHandler(){

            public void handle(ClientMessage message, Connection connection) {
                clientConnection.handleClientMessage(message);
            }
        });
        return new InitResult(inputBuffer, (Object)inboundHandler);
    }

    public InitResult<ChannelOutboundHandler> initOutbound(Channel channel) {
        ByteBuffer outputBuffer = IOUtil.newByteBuffer((int)this.bufferSize, (boolean)this.direct);
        outputBuffer.put(StringUtil.stringToBytes((String)"CB2"));
        return new InitResult(outputBuffer, (Object)new ClientMessageEncoder());
    }
}

