/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetAllScheduledFuturesCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorShutdownCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorSubmitToAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorSubmitToPartitionCodec;
import com.hazelcast.client.proxy.ClientScheduledFutureProxy;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.Member;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.NamedTask;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.ScheduledRunnableAdapter;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerImpl;
import com.hazelcast.scheduledexecutor.impl.TaskDefinition;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.UuidUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ClientScheduledExecutorProxy
extends PartitionSpecificClientProxy
implements IScheduledExecutorService {
    private static final int SHUTDOWN_TIMEOUT = 10;
    private static final ILogger LOGGER = Logger.getLogger(ClientScheduledExecutorProxy.class);
    private static final ClientMessageDecoder SUBMIT_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private final FutureUtil.ExceptionHandler shutdownExceptionHandler = new FutureUtil.ExceptionHandler(){

        public void handleException(Throwable throwable) {
            if (throwable != null) {
                if (throwable instanceof QuorumException) {
                    ExceptionUtil.sneakyThrow((Throwable)throwable);
                }
                if (throwable.getCause() instanceof QuorumException) {
                    ExceptionUtil.sneakyThrow((Throwable)throwable.getCause());
                }
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Exception while ExecutorService shutdown", throwable);
            }
        }
    };

    public ClientScheduledExecutorProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    public String toString() {
        return "ClientScheduledExecutorProxy{name='" + this.name + '\'' + '}';
    }

    public IScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        return this.schedule((Callable)adapter, delay, unit);
    }

    public <V> IScheduledFuture<V> schedule(Callable<V> command, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(command, (String)"Command is null");
        Preconditions.checkNotNull((Object)((Object)unit), (String)"Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getTaskOrKeyPartitionId(command, (Object)name);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    public IScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        Preconditions.checkNotNull((Object)command, (String)"Command is null");
        Preconditions.checkNotNull((Object)((Object)unit), (String)"Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getTaskOrKeyPartitionId(command, (Object)name);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    public IScheduledFuture<?> scheduleOnMember(Runnable command, Member member, long delay, TimeUnit unit) {
        Preconditions.checkNotNull((Object)member, (String)"Member is null");
        return this.scheduleOnMembers(command, Collections.singleton(member), delay, unit).get(member);
    }

    public <V> IScheduledFuture<V> scheduleOnMember(Callable<V> command, Member member, long delay, TimeUnit unit) {
        Preconditions.checkNotNull((Object)member, (String)"Member is null");
        return this.scheduleOnMembers(command, Collections.singleton(member), delay, unit).get(member);
    }

    public IScheduledFuture<?> scheduleOnMemberAtFixedRate(Runnable command, Member member, long initialDelay, long period, TimeUnit unit) {
        Preconditions.checkNotNull((Object)member, (String)"Member is null");
        return this.scheduleOnMembersAtFixedRate(command, Collections.singleton(member), initialDelay, period, unit).get(member);
    }

    public IScheduledFuture<?> scheduleOnKeyOwner(Runnable command, Object key, long delay, TimeUnit unit) {
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        return this.scheduleOnKeyOwner((Callable)adapter, key, delay, unit);
    }

    public <V> IScheduledFuture<V> scheduleOnKeyOwner(Callable<V> command, Object key, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(command, (String)"Command is null");
        Preconditions.checkNotNull((Object)key, (String)"Key is null");
        Preconditions.checkNotNull((Object)((Object)unit), (String)"Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getKeyPartitionId(key);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    public IScheduledFuture<?> scheduleOnKeyOwnerAtFixedRate(Runnable command, Object key, long initialDelay, long period, TimeUnit unit) {
        Preconditions.checkNotNull((Object)command, (String)"Command is null");
        Preconditions.checkNotNull((Object)key, (String)"Key is null");
        Preconditions.checkNotNull((Object)((Object)unit), (String)"Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getKeyPartitionId(key);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    public Map<Member, IScheduledFuture<?>> scheduleOnAllMembers(Runnable command, long delay, TimeUnit unit) {
        return this.scheduleOnMembers(command, this.getContext().getClusterService().getMemberList(), delay, unit);
    }

    public <V> Map<Member, IScheduledFuture<V>> scheduleOnAllMembers(Callable<V> command, long delay, TimeUnit unit) {
        return this.scheduleOnMembers(command, this.getContext().getClusterService().getMemberList(), delay, unit);
    }

    public Map<Member, IScheduledFuture<?>> scheduleOnAllMembersAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleOnMembersAtFixedRate(command, this.getContext().getClusterService().getMemberList(), initialDelay, period, unit);
    }

    public Map<Member, IScheduledFuture<?>> scheduleOnMembers(Runnable command, Collection<Member> members, long delay, TimeUnit unit) {
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        return this.scheduleOnMembers((Callable)adapter, members, delay, unit);
    }

    public <V> Map<Member, IScheduledFuture<V>> scheduleOnMembers(Callable<V> command, Collection<Member> members, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(command, (String)"Command is null");
        Preconditions.checkNotNull(members, (String)"Members is null");
        Preconditions.checkNotNull((Object)((Object)unit), (String)"Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        HashMap<Member, IScheduledFuture<IScheduledFuture<V>>> futures = new HashMap<Member, IScheduledFuture<IScheduledFuture<V>>>();
        for (Member member : members) {
            TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
            futures.put(member, this.scheduleOnMember(name, member, definition));
        }
        return futures;
    }

    public Map<Member, IScheduledFuture<?>> scheduleOnMembersAtFixedRate(Runnable command, Collection<Member> members, long initialDelay, long period, TimeUnit unit) {
        Preconditions.checkNotNull((Object)command, (String)"Command is null");
        Preconditions.checkNotNull(members, (String)"Members is null");
        Preconditions.checkNotNull((Object)((Object)unit), (String)"Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        HashMap futures = new HashMap();
        for (Member member : members) {
            TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
            futures.put(member, this.scheduleOnMember(name, member, definition));
        }
        return futures;
    }

    public <V> IScheduledFuture<V> getScheduledFuture(ScheduledTaskHandler handler) {
        ClientScheduledFutureProxy futureProxy = new ClientScheduledFutureProxy(handler, this.getContext());
        return futureProxy;
    }

    public <V> Map<Member, List<IScheduledFuture<V>>> getAllScheduledFutures() {
        ClientMessage response;
        ClientMessage request = ScheduledExecutorGetAllScheduledFuturesCodec.encodeRequest((String)this.getName());
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.getName()).invoke();
        try {
            response = (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        List urnsPerMember = ScheduledExecutorGetAllScheduledFuturesCodec.decodeResponse((ClientMessage)response).handlers;
        HashMap tasksMap = new HashMap();
        for (Map.Entry entry : urnsPerMember) {
            ArrayList memberTasks = new ArrayList();
            for (ScheduledTaskHandler scheduledTaskHandler : (List)entry.getValue()) {
                memberTasks.add(new ClientScheduledFutureProxy(scheduledTaskHandler, this.getContext()));
            }
            tasksMap.put((Member)entry.getKey(), memberTasks);
        }
        return tasksMap;
    }

    public void shutdown() {
        Collection<Member> members = this.getContext().getClusterService().getMemberList();
        LinkedList calls = new LinkedList();
        for (Member member : members) {
            ClientMessage request = ScheduledExecutorShutdownCodec.encodeRequest((String)this.getName(), (Address)member.getAddress());
            calls.add(this.doSubmitOnAddress(request, SUBMIT_DECODER, member.getAddress()));
        }
        FutureUtil.waitWithDeadline(calls, (long)10L, (TimeUnit)TimeUnit.SECONDS, (FutureUtil.ExceptionHandler)this.shutdownExceptionHandler);
    }

    private <T> ScheduledRunnableAdapter<T> createScheduledRunnableAdapter(Runnable command) {
        Preconditions.checkNotNull((Object)command, (String)"Command can't be null");
        return new ScheduledRunnableAdapter(command);
    }

    private <V> IScheduledFuture<V> createFutureProxy(ScheduledTaskHandler handler) {
        return new ClientScheduledFutureProxy(handler, this.getContext());
    }

    private <V> IScheduledFuture<V> createFutureProxy(int partitionId, String taskName) {
        return this.createFutureProxy(ScheduledTaskHandlerImpl.of((int)partitionId, (String)this.getName(), (String)taskName));
    }

    private <V> IScheduledFuture<V> createFutureProxy(Address address, String taskName) {
        return this.createFutureProxy(ScheduledTaskHandlerImpl.of((Address)address, (String)this.getName(), (String)taskName));
    }

    private int getKeyPartitionId(Object key) {
        return this.getClient().getPartitionService().getPartition(key).getPartitionId();
    }

    private int getTaskOrKeyPartitionId(Callable task, Object key) {
        Object newKey;
        if (task instanceof PartitionAware && (newKey = ((PartitionAware)task).getPartitionKey()) != null) {
            key = newKey;
        }
        return this.getKeyPartitionId(key);
    }

    private int getTaskOrKeyPartitionId(Runnable task, Object key) {
        Object newKey;
        if (task instanceof PartitionAware && (newKey = ((PartitionAware)task).getPartitionKey()) != null) {
            key = newKey;
        }
        return this.getKeyPartitionId(key);
    }

    private String extractNameOrGenerateOne(Object command) {
        String name = null;
        if (command instanceof NamedTask) {
            name = ((NamedTask)command).getName();
        }
        return name != null ? name : UuidUtil.newUnsecureUuidString();
    }

    private <V> IScheduledFuture<V> scheduleOnPartition(String name, TaskDefinition definition, int partitionId) {
        TimeUnit unit = definition.getUnit();
        Data commandData = this.getSerializationService().toData((Object)definition.getCommand());
        ClientMessage request = ScheduledExecutorSubmitToPartitionCodec.encodeRequest((String)this.getName(), (byte)definition.getType().getId(), (String)definition.getName(), (Data)commandData, (long)unit.toMillis(definition.getInitialDelay()), (long)unit.toMillis(definition.getPeriod()));
        try {
            new ClientInvocation(this.getClient(), request, this.getName(), partitionId).invoke().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return this.createFutureProxy(partitionId, name);
    }

    private <V> IScheduledFuture<V> scheduleOnMember(String name, Member member, TaskDefinition definition) {
        TimeUnit unit = definition.getUnit();
        Data commandData = this.getSerializationService().toData((Object)definition.getCommand());
        ClientMessage request = ScheduledExecutorSubmitToAddressCodec.encodeRequest((String)this.getName(), (Address)member.getAddress(), (byte)definition.getType().getId(), (String)definition.getName(), (Data)commandData, (long)unit.toMillis(definition.getInitialDelay()), (long)unit.toMillis(definition.getPeriod()));
        try {
            new ClientInvocation(this.getClient(), request, this.getName(), member.getAddress()).invoke().get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return this.createFutureProxy(member.getAddress(), name);
    }

    private <T> ClientDelegatingFuture<T> doSubmitOnAddress(ClientMessage clientMessage, ClientMessageDecoder clientMessageDecoder, Address address) {
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, this.getName(), address).invoke();
            return new ClientDelegatingFuture(future, this.getSerializationService(), clientMessageDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

