/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.LockForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.LockGetLockCountCodec;
import com.hazelcast.client.impl.protocol.codec.LockGetRemainingLeaseTimeCodec;
import com.hazelcast.client.impl.protocol.codec.LockIsLockedByCurrentThreadCodec;
import com.hazelcast.client.impl.protocol.codec.LockIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.LockLockCodec;
import com.hazelcast.client.impl.protocol.codec.LockTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.LockUnlockCodec;
import com.hazelcast.client.proxy.ClientConditionProxy;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class ClientLockProxy
extends PartitionSpecificClientProxy
implements ILock {
    private ClientLockReferenceIdGenerator referenceIdGenerator;

    public ClientLockProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    @Deprecated
    public Object getKey() {
        return this.name;
    }

    public boolean isLocked() {
        ClientMessage request = LockIsLockedCodec.encodeRequest((String)this.name);
        LockIsLockedCodec.ResponseParameters resultParameters = LockIsLockedCodec.decodeResponse((ClientMessage)this.invokeOnPartition(request));
        return resultParameters.response;
    }

    public boolean isLockedByCurrentThread() {
        ClientMessage request = LockIsLockedByCurrentThreadCodec.encodeRequest((String)this.name, (long)ThreadUtil.getThreadId());
        LockIsLockedByCurrentThreadCodec.ResponseParameters resultParameters = LockIsLockedByCurrentThreadCodec.decodeResponse((ClientMessage)this.invokeOnPartition(request));
        return resultParameters.response;
    }

    public int getLockCount() {
        ClientMessage request = LockGetLockCountCodec.encodeRequest((String)this.name);
        LockGetLockCountCodec.ResponseParameters resultParameters = LockGetLockCountCodec.decodeResponse((ClientMessage)this.invokeOnPartition(request));
        return resultParameters.response;
    }

    public long getRemainingLeaseTime() {
        ClientMessage request = LockGetRemainingLeaseTimeCodec.encodeRequest((String)this.name);
        LockGetRemainingLeaseTimeCodec.ResponseParameters resultParameters = LockGetRemainingLeaseTimeCodec.decodeResponse((ClientMessage)this.invokeOnPartition(request));
        return resultParameters.response;
    }

    public void lock(long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkPositive((long)leaseTime, (String)"leaseTime should be positive");
        ClientMessage request = LockLockCodec.encodeRequest((String)this.name, (long)this.getTimeInMillis(leaseTime, timeUnit), (long)ThreadUtil.getThreadId(), (long)this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartition(request);
    }

    public void forceUnlock() {
        ClientMessage request = LockForceUnlockCodec.encodeRequest((String)this.name, (long)this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartition(request);
    }

    public ICondition newCondition(String name) {
        Preconditions.checkNotNull((Object)name, (String)"Condition name can't be null");
        ClientConditionProxy clientConditionProxy = new ClientConditionProxy(this, name, this.getContext());
        clientConditionProxy.onInitialize();
        return clientConditionProxy;
    }

    public void lock() {
        ClientMessage request = LockLockCodec.encodeRequest((String)this.name, (long)-1L, (long)ThreadUtil.getThreadId(), (long)this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartition(request);
    }

    public void lockInterruptibly() throws InterruptedException {
        ClientMessage request = LockLockCodec.encodeRequest((String)this.name, (long)-1L, (long)ThreadUtil.getThreadId(), (long)this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartitionInterruptibly(request);
    }

    public boolean tryLock() {
        try {
            return this.tryLock(0L, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryLock(timeout, unit, Long.MAX_VALUE, null);
    }

    public boolean tryLock(long timeout, TimeUnit unit, long leaseTime, TimeUnit leaseUnit) throws InterruptedException {
        long timeoutInMillis = this.getTimeInMillis(timeout, unit);
        long leaseTimeInMillis = this.getTimeInMillis(leaseTime, leaseUnit);
        long threadId = ThreadUtil.getThreadId();
        ClientMessage request = LockTryLockCodec.encodeRequest((String)this.name, (long)threadId, (long)leaseTimeInMillis, (long)timeoutInMillis, (long)this.referenceIdGenerator.getNextReferenceId());
        LockTryLockCodec.ResponseParameters resultParameters = LockTryLockCodec.decodeResponse((ClientMessage)this.invokeOnPartition(request));
        return resultParameters.response;
    }

    public void unlock() {
        ClientMessage request = LockUnlockCodec.encodeRequest((String)this.name, (long)ThreadUtil.getThreadId(), (long)this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartition(request);
    }

    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    public String toString() {
        return "ILock{name='" + this.name + '\'' + '}';
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.referenceIdGenerator = this.getClient().getLockReferenceIdGenerator();
    }
}

