/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.client.cache.impl.AbstractClientInternalCacheProxy;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetCodec;
import com.hazelcast.client.impl.protocol.codec.CachePutAllCodec;
import com.hazelcast.client.impl.protocol.codec.CacheSizeCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.cache.CacheException;
import javax.cache.expiry.ExpiryPolicy;

abstract class AbstractClientCacheProxy<K, V>
extends AbstractClientInternalCacheProxy<K, V> {
    private static final ClientMessageDecoder CACHE_GET_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)CacheGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };

    AbstractClientCacheProxy(CacheConfig<K, V> cacheConfig, ClientContext context) {
        super(cacheConfig, context);
    }

    protected V getSyncInternal(Object key, ExpiryPolicy expiryPolicy) {
        long startNanos = this.nowInNanosOrDefault();
        try {
            ClientDelegatingFuture<V> future = this.getInternal(key, expiryPolicy, false);
            V value = future.get();
            if (this.statisticsEnabled) {
                this.statsHandler.onGet(startNanos, value != null);
            }
            return value;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public ICompletableFuture<V> getAsync(K key) {
        return this.getAsync(key, null);
    }

    public ICompletableFuture<V> getAsync(K key, ExpiryPolicy expiryPolicy) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        ExecutionCallback callback = !this.statisticsEnabled ? null : this.statsHandler.newOnGetCallback(startNanos);
        return this.getAsyncInternal(key, expiryPolicy, callback);
    }

    protected InternalCompletableFuture<V> getAsyncInternal(Object key, ExpiryPolicy expiryPolicy, ExecutionCallback<V> callback) {
        Data dataKey = this.toData(key);
        ClientDelegatingFuture<V> future = this.getInternal(dataKey, expiryPolicy, true);
        AbstractClientCacheProxy.addCallback(future, callback);
        return future;
    }

    private ClientDelegatingFuture<V> getInternal(Object key, ExpiryPolicy expiryPolicy, boolean deserializeResponse) {
        Data keyData = this.toData(key);
        Data expiryPolicyData = this.toData(expiryPolicy);
        ClientMessage request = CacheGetCodec.encodeRequest((String)this.nameWithPrefix, (Data)keyData, (Data)expiryPolicyData);
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, this.name, partitionId);
        ClientInvocationFuture future = clientInvocation.invoke();
        return this.newDelegatingFuture(future, CACHE_GET_RESPONSE_DECODER, deserializeResponse);
    }

    public ICompletableFuture<Void> putAsync(K key, V value) {
        return this.putAsync(key, value, null);
    }

    public ICompletableFuture<Void> putAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, false, true, this.newStatsCallbackOrNull(false));
    }

    public ICompletableFuture<Boolean> putIfAbsentAsync(K key, V value) {
        return (ICompletableFuture)this.putIfAbsentInternal(key, value, null, false, true);
    }

    public ICompletableFuture<Boolean> putIfAbsentAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return (ICompletableFuture)this.putIfAbsentInternal(key, value, expiryPolicy, false, true);
    }

    public ICompletableFuture<V> getAndPutAsync(K key, V value) {
        return this.getAndPutAsync(key, value, null);
    }

    public ICompletableFuture<V> getAndPutAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putAsyncInternal(key, value, expiryPolicy, true, false, this.newStatsCallbackOrNull(true));
    }

    public ICompletableFuture<Boolean> removeAsync(K key) {
        return (ICompletableFuture)this.removeAsyncInternal(key, null, false, false, true);
    }

    public ICompletableFuture<Boolean> removeAsync(K key, V oldValue) {
        return (ICompletableFuture)this.removeAsyncInternal(key, oldValue, true, false, true);
    }

    public ICompletableFuture<V> getAndRemoveAsync(K key) {
        return this.getAndRemoveAsyncInternal(key);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V value) {
        return this.replaceAsyncInternal(key, null, value, null, false, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, null, value, expiryPolicy, false, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsyncInternal(key, oldValue, newValue, null, true, false, true);
    }

    public ICompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        return this.replaceAsyncInternal(key, oldValue, newValue, expiryPolicy, true, false, true);
    }

    public ICompletableFuture<V> getAndReplaceAsync(K key, V value) {
        return this.replaceAndGetAsyncInternal(key, null, value, null, false, false, true);
    }

    public ICompletableFuture<V> getAndReplaceAsync(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceAndGetAsyncInternal(key, null, value, expiryPolicy, false, false, true);
    }

    public V get(K key, ExpiryPolicy expiryPolicy) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        return (V)this.toObject(this.getSyncInternal(key, expiryPolicy));
    }

    public Map<K, V> getAll(Set<? extends K> keys, ExpiryPolicy expiryPolicy) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        Preconditions.checkNotNull(keys, (String)"Null key is not allowed!");
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        int keysSize = keys.size();
        LinkedList<Data> dataKeys = new LinkedList<Data>();
        ArrayList<Object> resultingKeyValuePairs = new ArrayList<Object>(keysSize * 2);
        this.getAllInternal(keys, dataKeys, expiryPolicy, resultingKeyValuePairs, startNanos);
        Map result = MapUtil.createHashMap((int)keysSize);
        int i = 0;
        while (i < resultingKeyValuePairs.size()) {
            Object key = this.toObject(resultingKeyValuePairs.get(i++));
            Object value = this.toObject(resultingKeyValuePairs.get(i++));
            result.put(key, value);
        }
        return result;
    }

    protected void getAllInternal(Set<? extends K> keys, Collection<Data> dataKeys, ExpiryPolicy expiryPolicy, List<Object> resultingKeyValuePairs, long startNanos) {
        if (dataKeys.isEmpty()) {
            CollectionUtil.objectToDataCollection(keys, dataKeys, (SerializationService)this.getSerializationService(), (String)"Null key is not allowed!");
        }
        Data expiryPolicyData = this.toData(expiryPolicy);
        ClientMessage request = CacheGetAllCodec.encodeRequest((String)this.nameWithPrefix, dataKeys, (Data)expiryPolicyData);
        ClientMessage responseMessage = (ClientMessage)this.invoke(request);
        List response = CacheGetAllCodec.decodeResponse((ClientMessage)responseMessage).response;
        for (Map.Entry entry : response) {
            resultingKeyValuePairs.add(entry.getKey());
            resultingKeyValuePairs.add(entry.getValue());
        }
        if (this.statisticsEnabled) {
            this.statsHandler.onBatchGet(startNanos, response.size());
        }
    }

    public void put(K key, V value, ExpiryPolicy expiryPolicy) {
        this.putSyncInternal(key, value, expiryPolicy, false);
    }

    public V getAndPut(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.putSyncInternal(key, value, expiryPolicy, true);
    }

    public void putAll(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy) {
        long startNanos = this.nowInNanosOrDefault();
        this.ensureOpen();
        Preconditions.checkNotNull(map, (String)"map is null");
        if (map.isEmpty()) {
            return;
        }
        this.putAllInternal(map, expiryPolicy, null, new List[this.partitionCount], startNanos);
    }

    protected void putAllInternal(Map<? extends K, ? extends V> map, ExpiryPolicy expiryPolicy, Map<Object, Data> keyMap, List<Map.Entry<Data, Data>>[] entriesPerPartition, long startNanos) {
        try {
            this.groupDataToPartitions(map, this.getContext().getPartitionService(), keyMap, entriesPerPartition);
            this.putToAllPartitionsAndWaitForCompletion(entriesPerPartition, expiryPolicy, startNanos);
        }
        catch (Exception t) {
            throw ExceptionUtil.rethrow((Throwable)t);
        }
    }

    private void groupDataToPartitions(Map<? extends K, ? extends V> map, ClientPartitionService partitionService, Map<Object, Data> keyMap, List<Map.Entry<Data, Data>>[] entriesPerPartition) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            int partitionId;
            List<Map.Entry<Data, Data>> entries;
            K key = entry.getKey();
            V value = entry.getValue();
            CacheProxyUtil.validateNotNull(key, value);
            Data keyData = this.toData(key);
            Data valueData = this.toData(value);
            if (keyMap != null) {
                keyMap.put(key, keyData);
            }
            if ((entries = entriesPerPartition[partitionId = partitionService.getPartitionId(keyData)]) == null) {
                entriesPerPartition[partitionId] = entries = new ArrayList<Map.Entry<Data, Data>>();
            }
            entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, valueData));
        }
    }

    private void putToAllPartitionsAndWaitForCompletion(List<Map.Entry<Data, Data>>[] entriesPerPartition, ExpiryPolicy expiryPolicy, long startNanos) throws ExecutionException, InterruptedException {
        Data expiryPolicyData = this.toData(expiryPolicy);
        ArrayList<FutureEntriesTuple> futureEntriesTuples = new ArrayList<FutureEntriesTuple>(entriesPerPartition.length);
        for (int partitionId = 0; partitionId < entriesPerPartition.length; ++partitionId) {
            List<Map.Entry<Data, Data>> entries = entriesPerPartition[partitionId];
            if (entries == null) continue;
            int completionId = this.nextCompletionId();
            ClientMessage request = CachePutAllCodec.encodeRequest((String)this.nameWithPrefix, entries, (Data)expiryPolicyData, (int)completionId);
            ClientInvocationFuture future = this.invoke(request, partitionId, completionId);
            futureEntriesTuples.add(new FutureEntriesTuple((Future)((Object)future), entries));
        }
        this.waitResponseFromAllPartitionsForPutAll(futureEntriesTuples, startNanos);
    }

    private void waitResponseFromAllPartitionsForPutAll(List<FutureEntriesTuple> futureEntriesTuples, long startNanos) {
        Throwable error = null;
        for (FutureEntriesTuple tuple : futureEntriesTuples) {
            Future future = tuple.future;
            List entries = tuple.entries;
            try {
                future.get();
                if (!this.statisticsEnabled) continue;
                this.statsHandler.getStatistics().increaseCachePuts(entries.size());
            }
            catch (Throwable t) {
                this.logger.finest("Error occurred while putting entries as batch!", t);
                if (error != null) continue;
                error = t;
            }
        }
        if (this.statisticsEnabled) {
            this.statsHandler.getStatistics().addPutTimeNanos(this.nowInNanosOrDefault() - startNanos);
        }
        if (error != null) {
            throw ExceptionUtil.rethrow(error);
        }
    }

    public boolean putIfAbsent(K key, V value, ExpiryPolicy expiryPolicy) {
        return (Boolean)this.putIfAbsentInternal(key, value, expiryPolicy, true, false);
    }

    public boolean replace(K key, V oldValue, V newValue, ExpiryPolicy expiryPolicy) {
        return this.replaceSyncInternal(key, oldValue, newValue, expiryPolicy, true);
    }

    public boolean replace(K key, V value, ExpiryPolicy expiryPolicy) {
        return this.replaceSyncInternal(key, null, value, expiryPolicy, false);
    }

    public V getAndReplace(K key, V value, ExpiryPolicy expiryPolicy) {
        long startNanos = this.nowInNanosOrDefault();
        ICompletableFuture future = this.replaceAndGetAsyncInternal(key, null, value, expiryPolicy, false, true, false);
        try {
            Object oldValue = future.get();
            if (this.statisticsEnabled) {
                this.statsHandler.onReplace(true, startNanos, oldValue);
            }
            return oldValue;
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public int size() {
        this.ensureOpen();
        try {
            ClientMessage request = CacheSizeCodec.encodeRequest((String)this.nameWithPrefix);
            ClientMessage resultMessage = (ClientMessage)this.invoke(request);
            return CacheSizeCodec.decodeResponse((ClientMessage)resultMessage).response;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)t, CacheException.class);
        }
    }

    public CacheStatistics getLocalCacheStatistics() {
        return this.statsHandler.getStatistics();
    }

    private static final class FutureEntriesTuple {
        private final Future future;
        private final List<Map.Entry<Data, Data>> entries;

        private FutureEntriesTuple(Future future, List<Map.Entry<Data, Data>> entries) {
            this.future = future;
            this.entries = entries;
        }
    }
}

