/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.countdownlatch.client.AwaitRequest;
import com.hazelcast.concurrent.countdownlatch.client.CountDownRequest;
import com.hazelcast.concurrent.countdownlatch.client.GetCountRequest;
import com.hazelcast.concurrent.countdownlatch.client.SetCountRequest;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.TimeUnit;

public class ClientCountDownLatchProxy
extends ClientProxy
implements ICountDownLatch {
    private volatile Data key;

    public ClientCountDownLatchProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        AwaitRequest request = new AwaitRequest(this.getName(), this.getTimeInMillis(timeout, unit));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    public void countDown() {
        CountDownRequest request = new CountDownRequest(this.getName());
        this.invoke(request);
    }

    public int getCount() {
        GetCountRequest request = new GetCountRequest(this.getName());
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    public boolean trySetCount(int count) {
        SetCountRequest request = new SetCountRequest(this.getName(), count);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    protected void onDestroy() {
    }

    private Data toData(Object o) {
        return this.getContext().getSerializationService().toData(o);
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.getName());
        }
        return this.key;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private <T> T invoke(Object req) {
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, this.getKey());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

