/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientConfig {
    private GroupConfig groupConfig = new GroupConfig();
    private final List<String> addressList = new ArrayList<String>(10);
    private LoadBalancer loadBalancer;
    private List<ListenerConfig> listenerConfigs = new LinkedList<ListenerConfig>();
    private boolean smartRouting = true;
    private boolean redoOperation = false;
    private int connectionPoolSize = 100;
    private int connectionTimeout = 60000;
    private int connectionAttemptLimit = 2;
    private int connectionAttemptPeriod = 3000;
    private int executorPoolSize = -1;
    private SocketOptions socketOptions = new SocketOptions();
    private SerializationConfig serializationConfig = new SerializationConfig();
    private List<ProxyFactoryConfig> proxyFactoryConfigs = new LinkedList<ProxyFactoryConfig>();
    private SocketInterceptorConfig socketInterceptorConfig = null;
    private ManagedContext managedContext = null;
    private ClassLoader classLoader = null;
    private Credentials credentials;
    private Map<String, NearCacheConfig> nearCacheConfigMap = new HashMap<String, NearCacheConfig>();

    public ClientConfig addNearCacheConfig(String mapName, NearCacheConfig nearCacheConfig) {
        this.nearCacheConfigMap.put(mapName, nearCacheConfig);
        return this;
    }

    public ClientConfig addListenerConfig(ListenerConfig listenerConfig) {
        this.getListenerConfigs().add(listenerConfig);
        return this;
    }

    public ClientConfig addProxyFactoryConfig(ProxyFactoryConfig proxyFactoryConfig) {
        this.proxyFactoryConfigs.add(proxyFactoryConfig);
        return this;
    }

    public NearCacheConfig getNearCacheConfig(String mapName) {
        return ClientConfig.lookupByPattern(this.nearCacheConfigMap, mapName);
    }

    public Map<String, NearCacheConfig> getNearCacheConfigMap() {
        return this.nearCacheConfigMap;
    }

    public ClientConfig setNearCacheConfigMap(Map<String, NearCacheConfig> nearCacheConfigMap) {
        this.nearCacheConfigMap = nearCacheConfigMap;
        return this;
    }

    public boolean isSmartRouting() {
        return this.smartRouting;
    }

    public ClientConfig setSmartRouting(boolean smartRouting) {
        this.smartRouting = smartRouting;
        return this;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public ClientConfig setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public SocketInterceptorConfig getSocketInterceptorConfig() {
        return this.socketInterceptorConfig;
    }

    public ClientConfig setSocketInterceptorConfig(SocketInterceptorConfig socketInterceptorConfig) {
        this.socketInterceptorConfig = socketInterceptorConfig;
        return this;
    }

    public int getConnectionAttemptPeriod() {
        return this.connectionAttemptPeriod;
    }

    public ClientConfig setConnectionAttemptPeriod(int connectionAttemptPeriod) {
        this.connectionAttemptPeriod = connectionAttemptPeriod;
        return this;
    }

    public int getConnectionAttemptLimit() {
        return this.connectionAttemptLimit;
    }

    public ClientConfig setConnectionAttemptLimit(int connectionAttemptLimit) {
        this.connectionAttemptLimit = connectionAttemptLimit;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public ClientConfig setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Credentials getCredentials() {
        if (this.credentials == null) {
            this.setCredentials((Credentials)new UsernamePasswordCredentials(this.getGroupConfig().getName(), this.getGroupConfig().getPassword()));
        }
        return this.credentials;
    }

    public ClientConfig setCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public ClientConfig addAddress(String ... addresses) {
        Collections.addAll(this.addressList, addresses);
        return this;
    }

    public ClientConfig setAddresses(List<String> addresses) {
        this.addressList.clear();
        this.addressList.addAll(addresses);
        return this;
    }

    public List<String> getAddresses() {
        if (this.addressList.size() == 0) {
            this.addAddress("localhost");
        }
        return this.addressList;
    }

    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public ClientConfig setGroupConfig(GroupConfig groupConfig) {
        this.groupConfig = groupConfig;
        return this;
    }

    public List<ListenerConfig> getListenerConfigs() {
        return this.listenerConfigs;
    }

    public ClientConfig setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientConfig setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    public boolean isRedoOperation() {
        return this.redoOperation;
    }

    public ClientConfig setRedoOperation(boolean redoOperation) {
        this.redoOperation = redoOperation;
        return this;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public ClientConfig setSocketOptions(SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClientConfig setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ManagedContext getManagedContext() {
        return this.managedContext;
    }

    public ClientConfig setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    public int getExecutorPoolSize() {
        return this.executorPoolSize;
    }

    public ClientConfig setExecutorPoolSize(int executorPoolSize) {
        this.executorPoolSize = executorPoolSize;
        return this;
    }

    public List<ProxyFactoryConfig> getProxyFactoryConfigs() {
        return this.proxyFactoryConfigs;
    }

    public ClientConfig setProxyFactoryConfigs(List<ProxyFactoryConfig> proxyFactoryConfigs) {
        this.proxyFactoryConfigs = proxyFactoryConfigs;
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public ClientConfig setSerializationConfig(SerializationConfig serializationConfig) {
        this.serializationConfig = serializationConfig;
        return this;
    }

    private static <T> T lookupByPattern(Map<String, T> map, String name) {
        T t = map.get(name);
        if (t == null) {
            Set<String> tNames = map.keySet();
            for (String pattern : tNames) {
                if (!ClientConfig.nameMatches(name, pattern)) continue;
                return map.get(pattern);
            }
        }
        return t;
    }

    private static boolean nameMatches(String name, String pattern) {
        int index = pattern.indexOf(42);
        if (index == -1) {
            return name.equals(pattern);
        }
        String firstPart = pattern.substring(0, index);
        int indexFirstPart = name.indexOf(firstPart, 0);
        if (indexFirstPart == -1) {
            return false;
        }
        String secondPart = pattern.substring(index + 1);
        int indexSecondPart = name.indexOf(secondPart, index + 1);
        return indexSecondPart != -1;
    }
}

