/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.nearcache;

import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.ListenerSupport;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.client.MapAddEntryListenerRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Callback;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientNearCache {
    static final int evictionPercentage = 20;
    static final int cleanupInterval = 5000;
    final int maxSize;
    volatile long lastCleanup;
    final long maxIdleMillis;
    final long timeToLiveMillis;
    final boolean invalidateOnChange;
    final EvictionPolicy evictionPolicy;
    final InMemoryFormat inMemoryFormat;
    final String mapName;
    final ClientContext context;
    final AtomicBoolean canCleanUp;
    final AtomicBoolean canEvict;
    final ConcurrentMap<Data, CacheRecord> cache;
    ListenerSupport listenerSupport = null;
    public static final Object NULL_OBJECT = new Object();

    public ClientNearCache(String mapName, ClientContext context, NearCacheConfig nearCacheConfig) {
        this.mapName = mapName;
        this.context = context;
        this.maxSize = nearCacheConfig.getMaxSize();
        this.maxIdleMillis = nearCacheConfig.getMaxIdleSeconds() * 1000;
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        this.timeToLiveMillis = nearCacheConfig.getTimeToLiveSeconds() * 1000;
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.evictionPolicy = EvictionPolicy.valueOf(nearCacheConfig.getEvictionPolicy());
        this.cache = new ConcurrentHashMap<Data, CacheRecord>();
        this.canCleanUp = new AtomicBoolean(true);
        this.canEvict = new AtomicBoolean(true);
        this.lastCleanup = Clock.currentTimeMillis();
        if (this.invalidateOnChange) {
            this.addInvalidateListener();
        }
    }

    private void addInvalidateListener() {
        try {
            MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.mapName, false);
            EventHandler<PortableEntryEvent> handler = new EventHandler<PortableEntryEvent>(){

                @Override
                public void handle(PortableEntryEvent event) {
                    ClientNearCache.this.cache.remove(event.getKey());
                }
            };
            this.listenerSupport = new ListenerSupport(this.context, request, handler, null);
            this.listenerSupport.listen(new Callback<Exception>(){

                public void notify(Exception ignored) {
                    ClientNearCache.this.cache.clear();
                }
            });
        }
        catch (Exception e) {
            Logger.getLogger(ClientNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", (Throwable)e);
        }
    }

    public void put(Data key, Object object) {
        this.fireTtlCleanup();
        if (this.evictionPolicy == EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            return;
        }
        if (this.evictionPolicy != EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            this.fireEvictCache();
        }
        Object value = object == null ? NULL_OBJECT : (this.inMemoryFormat.equals((Object)InMemoryFormat.BINARY) ? this.context.getSerializationService().toData(object) : object);
        this.cache.put(key, new CacheRecord(key, value));
    }

    private void fireEvictCache() {
        if (this.canEvict.compareAndSet(true, false)) {
            try {
                this.context.getExecutionService().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TreeSet records = new TreeSet(ClientNearCache.this.cache.values());
                            int evictSize = ClientNearCache.this.cache.size() * 20 / 100;
                            int i = 0;
                            for (CacheRecord record : records) {
                                ClientNearCache.this.cache.remove(record.key);
                                if (++i <= evictSize) continue;
                                break;
                            }
                        }
                        finally {
                            ClientNearCache.this.canEvict.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canEvict.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    private void fireTtlCleanup() {
        if (Clock.currentTimeMillis() < this.lastCleanup + 5000L) {
            return;
        }
        if (this.canCleanUp.compareAndSet(true, false)) {
            try {
                this.context.getExecutionService().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            ClientNearCache.this.lastCleanup = Clock.currentTimeMillis();
                            for (Map.Entry entry : ClientNearCache.this.cache.entrySet()) {
                                if (!((CacheRecord)entry.getValue()).expired()) continue;
                                ClientNearCache.this.cache.remove(entry.getKey());
                            }
                        }
                        finally {
                            ClientNearCache.this.canCleanUp.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canCleanUp.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
    }

    public Object get(Data key) {
        this.fireTtlCleanup();
        CacheRecord record = (CacheRecord)this.cache.get(key);
        if (record != null) {
            if (record.expired()) {
                this.cache.remove(key);
                return null;
            }
            if (record.value.equals(NULL_OBJECT)) {
                return NULL_OBJECT;
            }
            record.access();
            return this.inMemoryFormat.equals((Object)InMemoryFormat.BINARY) ? this.context.getSerializationService().toObject((Data)record.value) : record.value;
        }
        return null;
    }

    public void destroy() {
        if (this.listenerSupport != null) {
            this.listenerSupport.stop();
        }
        this.cache.clear();
    }

    class CacheRecord
    implements Comparable<CacheRecord> {
        final Data key;
        final Object value;
        volatile long lastAccessTime;
        final long creationTime;
        final AtomicInteger hit;

        CacheRecord(Data key, Object value) {
            long time;
            this.key = key;
            this.value = value;
            this.lastAccessTime = time = Clock.currentTimeMillis();
            this.creationTime = time;
            this.hit = new AtomicInteger(0);
        }

        void access() {
            this.hit.incrementAndGet();
            this.lastAccessTime = Clock.currentTimeMillis();
        }

        boolean expired() {
            long time = Clock.currentTimeMillis();
            return ClientNearCache.this.maxIdleMillis > 0L && time > this.lastAccessTime + ClientNearCache.this.maxIdleMillis || ClientNearCache.this.timeToLiveMillis > 0L && time > this.creationTime + ClientNearCache.this.timeToLiveMillis;
        }

        @Override
        public int compareTo(CacheRecord o) {
            if (EvictionPolicy.LRU.equals((Object)ClientNearCache.this.evictionPolicy)) {
                return Long.valueOf(this.lastAccessTime).compareTo(o.lastAccessTime);
            }
            if (EvictionPolicy.LFU.equals((Object)ClientNearCache.this.evictionPolicy)) {
                return Integer.valueOf(this.hit.get()).compareTo(o.hit.get());
            }
            return 0;
        }
    }

    static enum EvictionPolicy {
        NONE,
        LRU,
        LFU;

    }
}

