/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection;

import com.hazelcast.client.connection.SocketFactory;
import com.hazelcast.nio.ssl.BasicSSLContextFactory;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public class SSLSocketFactory
implements SocketFactory {
    private final Properties properties;
    private final SSLContextFactory sslContextFactory;
    private volatile boolean initialized = false;

    public SSLSocketFactory() {
        this.sslContextFactory = new BasicSSLContextFactory();
        this.properties = new Properties();
    }

    public SSLSocketFactory(Properties properties) {
        this.properties = properties != null ? properties : new Properties();
        this.sslContextFactory = new BasicSSLContextFactory();
    }

    public SSLSocketFactory(SSLContextFactory sslContextFactory, Properties properties) {
        if (sslContextFactory == null) {
            throw new NullPointerException("SSLContextFactory is required!");
        }
        this.sslContextFactory = sslContextFactory;
        this.properties = properties != null ? properties : new Properties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLSocket createSocket() throws IOException {
        if (!this.initialized) {
            SSLSocketFactory sSLSocketFactory = this;
            synchronized (sSLSocketFactory) {
                if (!this.initialized) {
                    try {
                        this.sslContextFactory.init(this.properties);
                    }
                    catch (Exception e) {
                        throw ExceptionUtil.rethrow((Throwable)e, IOException.class);
                    }
                    this.initialized = true;
                }
            }
        }
        SSLContext sslContext = this.sslContextFactory.getSSLContext();
        javax.net.ssl.SSLSocketFactory factory = sslContext.getSocketFactory();
        return (SSLSocket)factory.createSocket();
    }
}

