/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.nio.serialization.SerializationService;

public final class ClientContext {
    private final SerializationService serializationService;
    private final ClientClusterService clusterService;
    private final ClientPartitionService partitionService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private final ProxyManager proxyManager;
    private final ClientConfig clientConfig;

    ClientContext(SerializationService serializationService, ClientClusterService clusterService, ClientPartitionService partitionService, ClientInvocationService invocationService, ClientExecutionService executionService, ProxyManager proxyManager, ClientConfig clientConfig) {
        this.serializationService = serializationService;
        this.clusterService = clusterService;
        this.partitionService = partitionService;
        this.invocationService = invocationService;
        this.executionService = executionService;
        this.proxyManager = proxyManager;
        this.clientConfig = clientConfig;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientClusterService getClusterService() {
        return this.clusterService;
    }

    public ClientPartitionService getPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientExecutionService getExecutionService() {
        return this.executionService;
    }

    public void removeProxy(ClientProxy proxy) {
        this.proxyManager.removeProxy(proxy.getServiceName(), proxy.getId());
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }
}

