/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.connection.Connection;
import com.hazelcast.client.spi.ResponseStream;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.io.IOException;

final class ResponseStreamImpl
implements ResponseStream {
    private final SerializationService serializationService;
    private final Connection connection;
    private boolean ended = false;

    ResponseStreamImpl(SerializationService serializationService, Connection connection) {
        this.serializationService = serializationService;
        this.connection = connection;
    }

    @Override
    public Object read() throws Exception {
        Data data = this.connection.read();
        return this.serializationService.toObject(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() throws IOException {
        ResponseStreamImpl responseStreamImpl = this;
        synchronized (responseStreamImpl) {
            if (!this.ended) {
                this.connection.close();
                this.ended = true;
            }
        }
    }
}

