/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.EntryHolder;
import com.hazelcast.client.ValueIterator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCollection<K, V>
implements Collection<V> {
    private final EntryHolder<K, V> proxy;
    private final Set<Map.Entry<K, V>> entrySet;

    public ValueCollection(EntryHolder<K, V> proxy, Set<Map.Entry<K, V>> entrySet) {
        this.proxy = proxy;
        this.entrySet = entrySet;
    }

    @Override
    public boolean add(V arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends V> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object arg0) {
        for (Map.Entry<K, V> anEntrySet : this.entrySet) {
            V object = anEntrySet.getValue();
            if (!object.equals(arg0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        for (Object object : arg0) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet.size() == 0;
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueIterator<K, V>(this.entrySet.iterator());
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return false;
    }

    @Override
    public int size() {
        return this.entrySet.size();
    }

    @Override
    public Object[] toArray() {
        ArrayList<V> list = new ArrayList<V>(this.entrySet.size());
        for (Map.Entry<K, V> entry : this.entrySet) {
            list.add(entry.getValue());
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a == null) {
            throw new NullPointerException();
        }
        int size = this.size();
        Object[] result = a.length < size ? (Object[])Array.newInstance(a.getClass().getComponentType(), size) : a;
        int i = 0;
        for (Map.Entry<K, V> entry : this.entrySet) {
            result[i++] = entry.getValue();
        }
        for (int j = i; j < a.length; ++j) {
            result[j] = null;
        }
        return result;
    }
}

