/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;

public class ClientConfigBuilder {
    private static final ILogger logger = Logger.getLogger((String)ClientConfigBuilder.class.getName());
    public static final String GROUP_NAME = "hazelcast.client.group.name";
    public static final String GROUP_PASS = "hazelcast.client.group.pass";
    public static final String CONNECTION_TIMEOUT = "hazelcast.client.connection.timeout";
    public static final String CONNECTION_ATTEMPT_LIMIT = "hazelcast.client.connection.attempts.limit";
    public static final String RECONNECTION_TIMEOUT = "hazelcast.client.reconnection.timeout";
    public static final String RECONNECTION_ATTEMPT_LIMIT = "hazelcast.client.reconnection.attempts.limit";
    public static final String SHUFFLE_ADDRESSES = "hazelcast.client.shuffle.addresses";
    public static final String UPDATE_AUTOMATIC = "hazelcast.client.update.automatic";
    public static final String ADDRESSES = "hazelcast.client.addresses";
    private final Properties props = new Properties();
    private final ClientConfig config = new ClientConfig();
    private String resource;

    public ClientConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig((String)resource);
        if (url == null) {
            throw new IllegalArgumentException("Could not load " + resource);
        }
        this.resource = resource;
        this.props.load(url.openStream());
    }

    public ClientConfigBuilder(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null!");
        }
        this.resource = file.getAbsolutePath();
        this.props.load(new FileInputStream(file));
    }

    public ClientConfigBuilder(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL is null!");
        }
        this.resource = url.toExternalForm();
        this.props.load(url.openStream());
    }

    public ClientConfigBuilder(InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("InputStream is null!");
        }
        this.props.load(in);
    }

    public ClientConfig build() {
        String addressesProp;
        logger.log(Level.INFO, "Building ClientConfig " + (this.resource != null ? " using " + this.resource : "") + ".");
        if (this.props.containsKey(GROUP_NAME)) {
            this.config.getGroupConfig().setName(this.props.getProperty(GROUP_NAME));
        }
        if (this.props.containsKey(GROUP_PASS)) {
            this.config.getGroupConfig().setPassword(this.props.getProperty(GROUP_PASS));
        }
        if (this.props.containsKey(CONNECTION_TIMEOUT)) {
            this.config.setConnectionTimeout(Integer.parseInt(this.props.getProperty(CONNECTION_TIMEOUT)));
        }
        if (this.props.containsKey(CONNECTION_ATTEMPT_LIMIT)) {
            this.config.setInitialConnectionAttemptLimit(Integer.parseInt(this.props.getProperty(CONNECTION_ATTEMPT_LIMIT)));
        }
        if (this.props.containsKey(RECONNECTION_TIMEOUT)) {
            this.config.setReConnectionTimeOut(Integer.parseInt(this.props.getProperty(RECONNECTION_TIMEOUT)));
        }
        if (this.props.containsKey(RECONNECTION_ATTEMPT_LIMIT)) {
            this.config.setReconnectionAttemptLimit(Integer.parseInt(this.props.getProperty(RECONNECTION_ATTEMPT_LIMIT)));
        }
        if (this.props.containsKey(SHUFFLE_ADDRESSES)) {
            this.config.setShuffle(Boolean.valueOf(this.props.getProperty(SHUFFLE_ADDRESSES)));
        }
        if (this.props.containsKey(UPDATE_AUTOMATIC)) {
            this.config.setUpdateAutomatic(Boolean.valueOf(this.props.getProperty(UPDATE_AUTOMATIC)));
        }
        if (this.props.containsKey(ADDRESSES) && (addressesProp = this.props.getProperty(ADDRESSES)) != null) {
            String[] addresses;
            for (String address : addresses = addressesProp.split("[,; ]")) {
                if ((address = address.trim()).length() <= 0) continue;
                this.config.addAddress(address);
            }
        }
        return this.config;
    }
}

