/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IOUtil;
import com.hazelcast.client.Packet;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MembershipListenerManager {
    private final List<MembershipListener> memberShipListeners = new CopyOnWriteArrayList<MembershipListener>();
    private final HazelcastClient client;

    public MembershipListenerManager(HazelcastClient client) {
        this.client = client;
        ClientConfig clientConfig = client.getClientConfig();
        if (clientConfig != null) {
            for (Object listener : clientConfig.getListeners()) {
                if (!(listener instanceof MembershipListener)) continue;
                this.registerListener((MembershipListener)listener);
            }
        }
    }

    public void registerListener(MembershipListener listener) {
        this.memberShipListeners.add(listener);
    }

    public void removeListener(MembershipListener listener) {
        this.memberShipListeners.remove(listener);
    }

    public boolean noListenerRegistered() {
        return this.memberShipListeners.isEmpty();
    }

    public void notifyListeners(Packet packet) {
        block4: {
            if (this.memberShipListeners.size() <= 0) break block4;
            Member member = (Member)IOUtil.toObject(packet.getKey());
            Integer type = (Integer)IOUtil.toObject(packet.getValue());
            MembershipEvent event = new MembershipEvent(this.client.getCluster(), member, type.intValue());
            if (type.equals(1)) {
                for (MembershipListener membershipListener : this.memberShipListeners) {
                    membershipListener.memberAdded(event);
                }
            } else {
                for (MembershipListener membershipListener : this.memberShipListeners) {
                    membershipListener.memberRemoved(event);
                }
            }
        }
    }
}

