/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientProperties {
    private final Map<ClientPropertyName, String> properties = new HashMap<ClientPropertyName, String>();

    public Map<ClientPropertyName, String> getProperties() {
        return this.properties;
    }

    public ClientProperties setProperties(Map<ClientPropertyName, String> properties) {
        for (Map.Entry<ClientPropertyName, String> entry : properties.entrySet()) {
            this.setPropertyValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ClientProperties setPropertyValue(String name, String value) {
        return this.setPropertyValue(ClientPropertyName.fromValue(name), value);
    }

    public ClientProperties setPropertyValue(ClientPropertyName name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String getProperty(String name) {
        return this.getProperty(ClientPropertyName.fromValue(name));
    }

    public String getProperty(ClientPropertyName name) {
        String string = this.properties.get((Object)name);
        if (string == null) {
            string = System.getProperty(name.getName());
        }
        if (string == null) {
            string = name.defaultValue;
        }
        if (string == null) {
            throw new IllegalStateException("property " + name.getName() + " is null");
        }
        return string;
    }

    public int getInteger(ClientPropertyName name) {
        return Integer.parseInt(this.getProperty(name));
    }

    public long getLong(ClientPropertyName name) {
        return Long.parseLong(this.getProperty(name));
    }

    public static ClientProperties createBaseClientProperties(String groupName, String groupPassword) {
        ClientProperties clientProperties = new ClientProperties();
        clientProperties.setPropertyValue(ClientPropertyName.GROUP_NAME, groupName);
        clientProperties.setPropertyValue(ClientPropertyName.GROUP_PASSWORD, groupPassword);
        return clientProperties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClientPropertyName {
        GROUP_NAME("hazelcast.client.group.name", null),
        GROUP_PASSWORD("hazelcast.client.group.password", null),
        INIT_CONNECTION_ATTEMPTS_LIMIT("hazelcast.client.init.connection.attempts.limit", "5"),
        RECONNECTION_ATTEMPTS_LIMIT("hazelcast.client.reconnection.attempts.limit", "5"),
        CONNECTION_TIMEOUT("hazelcast.client.connection.timeout", "300000"),
        RECONNECTION_TIMEOUT("hazelcast.client.reconnection.timeout", "5000");

        private final String name;
        private final String defaultValue;

        private ClientPropertyName(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public static ClientPropertyName fromValue(String name) {
            for (ClientPropertyName clientPropertyName : ClientPropertyName.values()) {
                if (!clientPropertyName.getName().equals(name)) continue;
                return clientPropertyName;
            }
            throw new IllegalArgumentException("There is no client property that has name '" + name + "'");
        }
    }
}

