/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.CollectionClientProxy;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.Instance;
import com.hazelcast.core.ItemListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.monitor.LocalQueueStats;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueClientProxy<E>
extends CollectionClientProxy<E>
implements IQueue<E> {
    public QueueClientProxy(HazelcastClient hazelcastClient, String name) {
        super(hazelcastClient, name);
    }

    public String getName() {
        return this.name.substring(2);
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.QUEUE;
    }

    @Override
    public boolean add(E e) {
        ProxyHelper.check(e);
        boolean result = this.offer(e);
        if (!result) {
            throw new IllegalStateException("no space is currently available");
        }
        return true;
    }

    @Override
    public String toString() {
        return "Queue{name='" + this.name + '\'' + '}';
    }

    public LocalQueueStats getLocalQueueStats() {
        throw new UnsupportedOperationException();
    }

    public boolean offer(E e) {
        ProxyHelper.check(e);
        return this.innerOffer(e, 0L);
    }

    public E poll() {
        return this.innerPoll(0L);
    }

    public E remove() {
        return (E)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_REMOVE, null, null);
    }

    public E peek() {
        return (E)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_PEEK, null, null);
    }

    public E element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.peek();
    }

    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        ProxyHelper.check(e);
        ProxyHelper.checkTime(l, timeUnit);
        long l2 = l = l < 0L ? 0L : l;
        if (e == null) {
            throw new NullPointerException();
        }
        return this.innerOffer(e, timeUnit.toMillis(l));
    }

    private boolean innerOffer(E e, long millis) {
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_OFFER, e, millis);
    }

    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        ProxyHelper.checkTime(l, timeUnit);
        l = l < 0L ? 0L : l;
        return this.innerPoll(timeUnit.toMillis(l));
    }

    private E innerPoll(long millis) {
        return (E)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_POLL, null, millis);
    }

    public E take() throws InterruptedException {
        return this.innerPoll(-1L);
    }

    public void put(E e) throws InterruptedException {
        ProxyHelper.check(e);
        this.innerOffer(e, -1L);
    }

    public int remainingCapacity() {
        throw new UnsupportedOperationException();
    }

    public int drainTo(Collection<? super E> objects) {
        return this.drainTo(objects, Integer.MAX_VALUE);
    }

    public int drainTo(Collection<? super E> objects, int i) {
        E e;
        int counter;
        if (objects == null) {
            throw new NullPointerException("drainTo null!");
        }
        if (i < 0) {
            throw new IllegalArgumentException("Negative maxElements:" + i);
        }
        if (i == 0) {
            return 0;
        }
        if (objects instanceof IQueue && ((IQueue)objects).getName().equals(this.getName())) {
            throw new IllegalArgumentException("Cannot drainTo self!");
        }
        for (counter = 0; (e = this.poll()) != null && counter < i; ++counter) {
            objects.add(e);
        }
        return counter;
    }

    @Override
    public int size() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.BLOCKING_QUEUE_SIZE, null, null);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IQueue && o != null) {
            return this.getName().equals(((IQueue)o).getName());
        }
        return false;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addItemListener(ItemListener<E> listener, boolean includeValue) {
        throw new UnsupportedOperationException();
    }
}

