/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientMapEntry;
import com.hazelcast.client.EntryHolder;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LightEntrySetSet;
import com.hazelcast.client.LightKeySet;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.ValueCollection;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.query.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapClientProxy<K, V>
implements IMap<K, V>,
EntryHolder {
    final ProxyHelper proxyHelper;
    private final String name;

    public MapClientProxy(HazelcastClient client, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, client);
    }

    public void addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        this.addEntryListener(listener, null, includeValue);
    }

    public void addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        ProxyHelper.check(listener);
        if (this.proxyHelper.getHazelcastClient().getListenerManager().getEntryListenerManager().noEntryListenerRegistered(key, this.name)) {
            Packet request = this.proxyHelper.createRequestPacket(ClusterOperation.ADD_LISTENER, Serializer.toByte(key), null);
            request.setLongValue(includeValue ? 1L : 0L);
            Call c = this.proxyHelper.createCall(request);
            this.proxyHelper.getHazelcastClient().getListenerManager().addListenerCall(c);
            this.proxyHelper.doCall(c);
        }
        this.proxyHelper.getHazelcastClient().getListenerManager().getEntryListenerManager().registerEntryListener(this.name, key, listener);
    }

    public void removeEntryListener(EntryListener<K, V> listener) {
        ProxyHelper.check(listener);
        this.proxyHelper.doOp(ClusterOperation.REMOVE_LISTENER, null, null);
        this.proxyHelper.getHazelcastClient().getListenerManager().getEntryListenerManager().removeEntryListener(this.name, null, listener);
    }

    public void removeEntryListener(EntryListener<K, V> listener, K key) {
        ProxyHelper.check(listener);
        ProxyHelper.check(key);
        this.proxyHelper.doOp(ClusterOperation.REMOVE_LISTENER, key, null);
        this.proxyHelper.getHazelcastClient().getListenerManager().getEntryListenerManager().removeEntryListener(this.name, key, listener);
    }

    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        Collection collection = this.proxyHelper.entries(predicate);
        return new LightEntrySetSet(collection, this, this.getInstanceType());
    }

    public boolean evict(Object key) {
        ProxyHelper.check(key);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_EVICT, key, null);
    }

    public MapEntry<K, V> getMapEntry(K key) {
        ProxyHelper.check(key);
        CMap.CMapEntry cMapEntry = (CMap.CMapEntry)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY, key, null);
        if (cMapEntry == null) {
            return null;
        }
        return new ClientMapEntry(cMapEntry, key, this);
    }

    public Set<K> keySet(Predicate predicate) {
        Collection collection = this.proxyHelper.keys(predicate);
        return new LightKeySet(this, new HashSet(collection));
    }

    public boolean lockMap(long time, TimeUnit timeunit) {
        ProxyHelper.checkTime(time, timeunit);
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK_MAP, null, time, timeunit);
    }

    public void unlockMap() {
        this.doLock(ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP, null, -1L, null);
    }

    public void lock(K key) {
        ProxyHelper.check(key);
        this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK, key, -1L, null);
    }

    public boolean tryLock(K key) {
        ProxyHelper.check(key);
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK, key, 0L, null);
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) {
        ProxyHelper.check(key);
        ProxyHelper.checkTime(time, timeunit);
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK, key, time, timeunit);
    }

    public void unlock(K key) {
        ProxyHelper.check(key);
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_UNLOCK, key, null);
    }

    public Collection<V> values(Predicate predicate) {
        Set<Map.Entry<K, V>> set = this.entrySet(predicate);
        return new ValueCollection<K, V>(this, set);
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        ProxyHelper.checkTime(ttl, timeunit);
        long micros = timeunit.toMillis(ttl);
        Packet request = this.proxyHelper.prepareRequest(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, key, value);
        request.setTimeout(micros);
        Packet response = this.proxyHelper.callAndGetResult(request);
        return (V)this.proxyHelper.getValue(response);
    }

    public V putIfAbsent(K key, V value) {
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, key, value);
    }

    @Override
    public boolean remove(Object arg0, Object arg1) {
        ProxyHelper.check(arg0);
        ProxyHelper.check(arg1);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME, arg0, arg1);
    }

    public V replace(K arg0, V arg1) {
        ProxyHelper.check(arg0);
        ProxyHelper.check(arg1);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL, arg0, arg1);
    }

    public boolean replace(K arg0, V arg1, V arg2) {
        ProxyHelper.check(arg0);
        ProxyHelper.check(arg1);
        ProxyHelper.check(arg2);
        Object[] arr = new Object[]{arg1, arg2};
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME, arg0, arr);
    }

    public void clear() {
        Set<K> keys = this.keySet();
        for (K key : keys) {
            this.remove(key);
        }
    }

    public boolean containsKey(Object arg0) {
        ProxyHelper.check(arg0);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS, arg0, null);
    }

    @Override
    public boolean containsValue(Object arg0) {
        ProxyHelper.check(arg0);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, null, arg0);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet(null);
    }

    public V get(Object key) {
        ProxyHelper.check(key);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_GET, key, null);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException();
    }

    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    public LocalMapStats getLocalMapStats() {
        throw new UnsupportedOperationException();
    }

    public Set<K> keySet() {
        return this.keySet(null);
    }

    public Future<V> getAsync(K key) {
        ProxyHelper.check(key);
        return this.proxyHelper.doAsync(ClusterOperation.CONCURRENT_MAP_GET, key, null);
    }

    public Future<V> putAsync(K key, V value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return this.proxyHelper.doAsync(ClusterOperation.CONCURRENT_MAP_PUT, key, value);
    }

    public V put(K key, V value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT, key, value);
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        throw new UnsupportedOperationException();
    }

    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        ArrayList<Future<V>> lsFutures = new ArrayList<Future<V>>(map.size());
        for (K k : map.keySet()) {
            V value = map.get(k);
            lsFutures.add(this.putAsync(k, value));
        }
        for (Future future : lsFutures) {
            try {
                future.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public V remove(Object arg0) {
        ProxyHelper.check(arg0);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE, arg0, null);
    }

    private Object doLock(ClusterOperation operation, Object key, long timeout, TimeUnit timeUnit) {
        Packet request = this.proxyHelper.prepareRequest(operation, key, (Object)timeUnit);
        request.setTimeout(timeout);
        Packet response = this.proxyHelper.callAndGetResult(request);
        return this.proxyHelper.getValue(response);
    }

    @Override
    public int size() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_SIZE, null, null);
    }

    public Collection<V> values() {
        return this.values(null);
    }

    public Object getId() {
        return this.name;
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.MAP;
    }

    public void addIndex(String attribute, boolean ordered) {
        this.proxyHelper.doOp(ClusterOperation.ADD_INDEX, attribute, ordered);
    }

    public String getName() {
        return this.name.substring(2);
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public boolean equals(Object o) {
        if (o instanceof IMap && o != null) {
            return this.getName().equals(((IMap)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

