/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class LifecycleServiceClientImpl
implements LifecycleService {
    static final ILogger logger = Logger.getLogger((String)LifecycleServiceClientImpl.class.getName());
    final AtomicBoolean paused = new AtomicBoolean(false);
    final AtomicBoolean running = new AtomicBoolean(true);
    final CopyOnWriteArrayList<LifecycleListener> lsLifecycleListeners = new CopyOnWriteArrayList();
    final Object lifecycleLock = new Object();
    final HazelcastClient hazelcastClient;

    public LifecycleServiceClientImpl(HazelcastClient hazelcastClient) {
        this.hazelcastClient = hazelcastClient;
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lsLifecycleListeners.add(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lsLifecycleListeners.remove(lifecycleListener);
    }

    public void fireLifecycleEvent(LifecycleEvent lifecycleEvent) {
        logger.log(Level.INFO, "HazelcastClient is " + lifecycleEvent.getState());
        for (LifecycleListener lifecycleListener : this.lsLifecycleListeners) {
            lifecycleListener.stateChanged(lifecycleEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pause() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.paused.get()) {
                return false;
            }
            this.fireLifecycleEvent(new LifecycleEvent(LifecycleEvent.LifecycleState.PAUSING));
            this.paused.set(true);
            this.fireLifecycleEvent(new LifecycleEvent(LifecycleEvent.LifecycleState.PAUSED));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (!this.paused.get()) {
                return false;
            }
            this.fireLifecycleEvent(new LifecycleEvent(LifecycleEvent.LifecycleState.RESUMING));
            this.paused.set(false);
            this.fireLifecycleEvent(new LifecycleEvent(LifecycleEvent.LifecycleState.RESUMED));
            return true;
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            long begin = System.currentTimeMillis();
            this.fireLifecycleEvent(new LifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN));
            this.hazelcastClient.doShutdown();
            this.running.set(false);
            long time = System.currentTimeMillis() - begin;
            logger.log(Level.FINE, "HazelcastClient shutdown completed in " + time + " ms.");
            this.fireLifecycleEvent(new LifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN));
        }
    }

    public void restart() {
        throw new UnsupportedOperationException();
    }
}

