/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.impl.MessageListenerManager;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MessageListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.monitor.LocalTopicStats;
import java.util.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicClientProxy<T>
implements ITopic {
    private final String name;
    private final ProxyHelper proxyHelper;
    private final Object lock = new Object();

    public TopicClientProxy(HazelcastClient hazelcastClient, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, hazelcastClient);
    }

    public String getName() {
        return this.name.substring("t:".length());
    }

    public void publish(Object message) {
        ProxyHelper.check(message);
        this.proxyHelper.doOp(ClusterOperation.TOPIC_PUBLISH, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(MessageListener messageListener) {
        ProxyHelper.check((EventListener)messageListener);
        Object object = this.lock;
        synchronized (object) {
            boolean shouldCall = this.messageListenerManager().noListenerRegistered(this.name);
            this.messageListenerManager().registerListener(this.name, messageListener);
            if (shouldCall) {
                this.doAddListenerCall(messageListener);
            }
        }
    }

    private void doAddListenerCall(MessageListener messageListener) {
        Call c = this.messageListenerManager().createNewAddListenerCall(this.proxyHelper);
        this.proxyHelper.doCall(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(MessageListener messageListener) {
        ProxyHelper.check((EventListener)messageListener);
        Object object = this.lock;
        synchronized (object) {
            this.messageListenerManager().removeListener(this.name, messageListener);
            if (this.messageListenerManager().noListenerRegistered(this.name)) {
                this.proxyHelper.doOp(ClusterOperation.REMOVE_LISTENER, null, null);
            }
        }
    }

    private MessageListenerManager messageListenerManager() {
        return this.proxyHelper.getHazelcastClient().getListenerManager().getMessageListenerManager();
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.TOPIC;
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof ITopic) {
            return this.getName().equals(((ITopic)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException();
    }
}

