/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.nio;

import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Address
implements DataSerializable {
    private static final long serialVersionUID = -7626390274220424603L;
    private String host = null;
    private byte[] ip;
    private int port = -1;
    private transient InetAddress inetAddress;
    private int hash = -1;
    private boolean thisAddress = false;

    public Address() {
        this.ip = new byte[4];
    }

    public Address(InetAddress inetAddress, int port) {
        this.ip = inetAddress.getAddress();
        this.port = port;
        this.inetAddress = inetAddress;
    }

    public Address(Address address) {
        this.ip = new byte[4];
        System.arraycopy(address.getIP(), 0, this.ip, 0, 4);
        this.port = address.getPort();
    }

    public Address(String address, int port) throws UnknownHostException {
        this(address, port, false);
    }

    public Address(String address, int port, boolean ipAddress) throws UnknownHostException {
        this.port = port;
        if (!ipAddress) {
            this.ip = InetAddress.getByName(address).getAddress();
        } else {
            this.ip = new byte[4];
            StringTokenizer stringTokenizer = new StringTokenizer(address, ".");
            int index = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String token = stringTokenizer.nextToken();
                int addressByte = Integer.parseInt(token);
                this.ip[index++] = (byte)addressByte;
            }
        }
    }

    public boolean isThisAddress() {
        return this.thisAddress;
    }

    public void setThisAddress(boolean thisAddress) {
        this.thisAddress = thisAddress;
    }

    public Address(byte[] ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public static String toString(byte[] ip) {
        return (ip[0] & 0xFF) + "." + (ip[1] & 0xFF) + "." + (ip[2] & 0xFF) + "." + (ip[3] & 0xFF);
    }

    private void setHost() {
        this.host = Address.toString(this.ip);
    }

    public void writeData(DataOutput out) throws IOException {
        out.write(this.ip);
        out.writeInt(this.port);
    }

    public void readData(DataInput in) throws IOException {
        in.readFully(this.ip);
        this.port = in.readInt();
    }

    public String getHost() {
        if (this.host == null) {
            this.setHost();
        }
        return this.host;
    }

    public String toString() {
        if (this.host == null) {
            this.setHost();
        }
        return "Address[" + this.host + ":" + this.port + "]";
    }

    public int getPort() {
        return this.port;
    }

    public String addressToString() {
        if (this.host == null) {
            this.setHost();
        }
        return this.host;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.host == null) {
            this.setHost();
        }
        if (this.inetAddress == null) {
            this.inetAddress = InetAddress.getByName(this.host);
        }
        return this.inetAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address address = (Address)o;
        return this.port == address.port && Arrays.equals(this.ip, address.ip);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.setHashCode();
        }
        return this.hash;
    }

    private void setHashCode() {
        this.hash = this.hash(this.ip) * 29 + this.port;
    }

    private int hash(byte[] id) {
        int hash = 0;
        for (byte anId : id) {
            hash = hash * 29 + anId;
        }
        return hash;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public byte[] getIP() {
        return this.ip;
    }
}

