/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.Serializer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureProxy<T>
implements Future<T> {
    final Callable<T> callable;
    final ProxyHelper proxyHelper;
    volatile boolean isDone = false;
    private T result;
    BlockingQueue<Packet> queue = new LinkedBlockingQueue<Packet>();

    public FutureProxy(ProxyHelper proxyHelper, Callable<T> callable) {
        this.proxyHelper = proxyHelper;
        this.callable = callable;
    }

    @Override
    public boolean cancel(boolean b) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(-1L, null);
        }
        catch (TimeoutException ignore) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.result == null) {
            FutureProxy futureProxy = this;
            synchronized (futureProxy) {
                if (this.result == null) {
                    Packet packet = null;
                    packet = l < 0L ? this.queue.take() : this.queue.poll(l, timeUnit);
                    this.result = this.handleResult(packet);
                }
            }
        }
        return this.result;
    }

    private T handleResult(Packet packet) throws ExecutionException {
        Object o = Serializer.toObject(packet.getValue());
        if (o instanceof ExecutionException) {
            throw (ExecutionException)o;
        }
        return (T)o;
    }

    public void enqueue(Packet packet) {
        this.queue.offer(packet);
        this.isDone = true;
    }
}

