/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryListenerManager {
    private final Map<String, Map<Object, List<EntryListener<?, ?>>>> entryListeners = new ConcurrentHashMap();

    public synchronized void registerEntryListener(String name, Object key, EntryListener<?, ?> entryListener) {
        if (!this.entryListeners.containsKey(name)) {
            this.entryListeners.put(name, new HashMap());
        }
        if (!this.entryListeners.get(name).containsKey(key)) {
            this.entryListeners.get(name).put(key, new CopyOnWriteArrayList());
        }
        this.entryListeners.get(name).get(key).add(entryListener);
    }

    public synchronized void removeEntryListener(String name, Object key, EntryListener<?, ?> entryListener) {
        Map<Object, List<EntryListener<?, ?>>> m = this.entryListeners.get(name);
        if (m != null) {
            List<EntryListener<?, ?>> list = m.get(key);
            if (list != null) {
                list.remove(entryListener);
                if (m.get(key).size() == 0) {
                    m.remove(key);
                }
            }
            if (m.size() == 0) {
                this.entryListeners.remove(name);
            }
        }
    }

    public synchronized boolean noEntryListenerRegistered(Object key, String name) {
        return this.entryListeners.get(name) == null || this.entryListeners.get(name).get(key) == null || this.entryListeners.get(name).get(key).size() <= 0;
    }

    public void notifyEntryListeners(Packet packet) {
        EntryEvent event = new EntryEvent((Object)packet.getName(), null, (int)packet.getLongValue(), Serializer.toObject(packet.getKey()), Serializer.toObject(packet.getValue()));
        String name = event.getName();
        Object key = event.getKey();
        if (this.entryListeners.get(name) != null) {
            this.notifyEntryListeners(event, (Collection)this.entryListeners.get(name).get(null));
            this.notifyEntryListeners(event, (Collection)this.entryListeners.get(name).get(key));
        }
    }

    private void notifyEntryListeners(EntryEvent event, Collection<EntryListener<?, ?>> collection) {
        if (collection == null) {
            return;
        }
        switch (event.getEventType()) {
            case ADDED: {
                for (EntryListener<?, ?> entryListener : collection) {
                    entryListener.entryAdded(event);
                }
                break;
            }
            case UPDATED: {
                for (EntryListener<?, ?> entryListener : collection) {
                    entryListener.entryUpdated(event);
                }
                break;
            }
            case REMOVED: {
                for (EntryListener<?, ?> entryListener : collection) {
                    entryListener.entryRemoved(event);
                }
                break;
            }
            case EVICTED: {
                for (EntryListener<?, ?> entryListener : collection) {
                    entryListener.entryEvicted(event);
                }
                break;
            }
        }
    }
}

