/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.util.ByteUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Packet {
    private byte[] headerInBytes;
    private byte[] key;
    private byte[] value;
    private String name;
    private ClusterOperation operation;
    private int blockId = 0;
    private int threadId;
    private int lockCount = 0;
    private long ttl = -1L;
    private long timeout = -1L;
    private long txnId = -1L;
    private long longValue;
    private long version = -1L;
    private byte responseType = (byte)2;
    private long callId = -1L;
    private byte indexCount = 0;
    private long[] indexes = new long[10];
    private byte[] indexTypes = new byte[10];
    private static final byte PACKET_VERSION = 5;
    private static final ByteBuffer readHeaderBuffer = ByteBuffer.allocate(1000);
    private static final ByteBuffer writeHeaderBuffer = ByteBuffer.allocate(1000);

    public void writeTo(DataOutputStream outputStream) throws IOException {
        ByteBuffer header = this.getHeader();
        int headerSize = header.position();
        outputStream.writeInt(headerSize);
        outputStream.writeInt(this.key == null ? 0 : this.key.length);
        outputStream.writeInt(this.value == null ? 0 : this.value.length);
        outputStream.writeByte(5);
        outputStream.write(header.array(), 0, headerSize);
        if (this.key != null) {
            outputStream.write(this.key);
        }
        if (this.value != null) {
            outputStream.write(this.value);
        }
    }

    public void readFrom(DataInputStream dis) throws IOException {
        int headerSize = dis.readInt();
        int keySize = dis.readInt();
        int valueSize = dis.readInt();
        byte packetVersion = dis.readByte();
        if (packetVersion != 5) {
            throw new RuntimeException("Invalid packet version. Expected:5, Found:" + packetVersion);
        }
        readHeaderBuffer.clear();
        readHeaderBuffer.limit(headerSize);
        dis.readFully(readHeaderBuffer.array(), 0, headerSize);
        this.operation = ClusterOperation.create((int)readHeaderBuffer.get());
        this.blockId = readHeaderBuffer.getInt();
        this.threadId = readHeaderBuffer.getInt();
        byte booleans = readHeaderBuffer.get();
        if (ByteUtil.isTrue((byte)booleans, (int)0)) {
            this.lockCount = readHeaderBuffer.getInt();
        }
        if (ByteUtil.isTrue((byte)booleans, (int)1)) {
            this.timeout = readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue((byte)booleans, (int)2)) {
            this.ttl = readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue((byte)booleans, (int)3)) {
            this.txnId = readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue((byte)booleans, (int)4)) {
            this.longValue = readHeaderBuffer.getLong();
        }
        if (ByteUtil.isTrue((byte)booleans, (int)5)) {
            this.version = readHeaderBuffer.getLong();
        }
        if (!ByteUtil.isTrue((byte)booleans, (int)7)) {
            throw new RuntimeException("LockAddress cannot be sent to the client!" + this.operation);
        }
        this.callId = readHeaderBuffer.getLong();
        this.responseType = readHeaderBuffer.get();
        int nameLength = readHeaderBuffer.getInt();
        if (nameLength > 0) {
            byte[] b = new byte[nameLength];
            readHeaderBuffer.get(b);
            this.name = new String(b);
        }
        this.indexCount = readHeaderBuffer.get();
        for (int i = 0; i < this.indexCount; ++i) {
            this.indexes[i] = readHeaderBuffer.getLong();
            this.indexTypes[i] = readHeaderBuffer.get();
        }
        this.key = new byte[keySize];
        dis.readFully(this.key);
        this.value = new byte[valueSize];
        dis.readFully(this.value);
    }

    private ByteBuffer getHeader() throws IOException {
        writeHeaderBuffer.clear();
        writeHeaderBuffer.put(this.operation.getValue());
        writeHeaderBuffer.putInt(this.blockId);
        writeHeaderBuffer.putInt(this.threadId);
        byte booleans = 0;
        if (this.lockCount != 0) {
            booleans = ByteUtil.setTrue((byte)booleans, (int)0);
        }
        if (this.timeout != -1L) {
            booleans = ByteUtil.setTrue((byte)booleans, (int)1);
        }
        if (this.ttl != -1L) {
            booleans = ByteUtil.setTrue((byte)booleans, (int)2);
        }
        if (this.txnId != -1L) {
            booleans = ByteUtil.setTrue((byte)booleans, (int)3);
        }
        if (this.longValue != Long.MIN_VALUE) {
            booleans = ByteUtil.setTrue((byte)booleans, (int)4);
        }
        if (this.version != -1L) {
            booleans = ByteUtil.setTrue((byte)booleans, (int)5);
        }
        booleans = ByteUtil.setTrue((byte)booleans, (int)6);
        booleans = ByteUtil.setTrue((byte)booleans, (int)7);
        writeHeaderBuffer.put(booleans);
        if (this.lockCount != 0) {
            writeHeaderBuffer.putInt(this.lockCount);
        }
        if (this.timeout != -1L) {
            writeHeaderBuffer.putLong(this.timeout);
        }
        if (this.ttl != -1L) {
            writeHeaderBuffer.putLong(this.ttl);
        }
        if (this.txnId != -1L) {
            writeHeaderBuffer.putLong(this.txnId);
        }
        if (this.longValue != Long.MIN_VALUE) {
            writeHeaderBuffer.putLong(this.longValue);
        }
        if (this.version != -1L) {
            writeHeaderBuffer.putLong(this.version);
        }
        writeHeaderBuffer.putLong(this.callId);
        writeHeaderBuffer.put(this.responseType);
        int nameLen = 0;
        byte[] nameInBytes = null;
        if (this.name != null) {
            nameInBytes = this.name.getBytes();
            nameLen = nameInBytes.length;
        }
        writeHeaderBuffer.putInt(nameLen);
        if (nameLen > 0) {
            writeHeaderBuffer.put(nameInBytes);
        }
        writeHeaderBuffer.put(this.indexCount);
        for (int i = 0; i < this.indexCount; ++i) {
            writeHeaderBuffer.putLong(this.indexes[i]);
            writeHeaderBuffer.put(this.indexTypes[i]);
        }
        return writeHeaderBuffer;
    }

    public void set(String name, ClusterOperation operation, byte[] key, byte[] value) {
        this.name = name;
        this.operation = operation;
        this.setKey(key);
        this.setValue(value);
    }

    public byte[] getKey() {
        return this.key;
    }

    public void setKey(byte[] key) {
        this.key = key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setCallId(long callid) {
        this.callId = callid;
    }

    public long getCallId() {
        return this.callId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClusterOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ClusterOperation operation) {
        this.operation = operation;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public void setBlockId(int blockId) {
        this.blockId = blockId;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    public int getLockCount() {
        return this.lockCount;
    }

    public void setLockCount(int lockCount) {
        this.lockCount = lockCount;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTxnId() {
        return this.txnId;
    }

    public void setTxnId(long txnId) {
        this.txnId = txnId;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long longValue) {
        this.longValue = longValue;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public byte getResponseType() {
        return this.responseType;
    }

    public void setResponseType(byte responseType) {
        this.responseType = responseType;
    }

    public byte getIndexCount() {
        return this.indexCount;
    }

    public void setIndexCount(byte indexCount) {
        this.indexCount = indexCount;
    }

    public long[] getIndexes() {
        return this.indexes;
    }

    public void setIndexes(long[] indexes) {
        this.indexes = indexes;
    }

    public byte[] getIndexTypes() {
        return this.indexTypes;
    }

    public void setIndexTypes(byte[] indexTypes) {
        this.indexTypes = indexTypes;
    }

    public void clearForResponse() {
        this.name = null;
        this.key = null;
        this.value = null;
        this.blockId = -1;
        this.timeout = -1L;
        this.ttl = -1L;
        this.txnId = -1L;
        this.threadId = -1;
        this.lockCount = 0;
        this.longValue = Long.MIN_VALUE;
        this.version = -1L;
        this.indexes = null;
        this.indexTypes = null;
    }

    public String toString() {
        return "Packet [callId = " + this.callId + "  name = " + this.name + " operation = " + this.operation + "]";
    }
}

