/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.EntryHolder;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LightKeySet;
import com.hazelcast.client.LightMultiMapEntrySet;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.ValueCollection;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MultiMap;
import com.hazelcast.impl.ClusterOperation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiMapClientProxy<K, V>
implements MultiMap<K, V>,
EntryHolder {
    private final String name;
    private final ProxyHelper proxyHelper;
    private final HazelcastClient client;

    public MultiMapClientProxy(HazelcastClient client, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, client);
        this.client = client;
    }

    public String getName() {
        return this.name.substring(4);
    }

    public void addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        this.addEntryListener(listener, null, includeValue);
    }

    public void addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        ProxyHelper.check(listener);
        if (this.client.getListenerManager().getEntryListenerManager().noEntryListenerRegistered(key, this.name)) {
            Packet request = this.proxyHelper.createRequestPacket(ClusterOperation.ADD_LISTENER, Serializer.toByte(key), null);
            request.setLongValue(includeValue ? 1L : 0L);
            Call c = this.proxyHelper.createCall(request);
            this.client.getListenerManager().addListenerCall(c);
            this.proxyHelper.doCall(c);
        }
        this.client.getListenerManager().getEntryListenerManager().registerEntryListener(this.name, key, listener);
    }

    public void removeEntryListener(EntryListener<K, V> listener) {
        ProxyHelper.check(listener);
        this.proxyHelper.doOp(ClusterOperation.REMOVE_LISTENER, null, null);
        this.client.getListenerManager().getEntryListenerManager().removeEntryListener(this.name, null, listener);
    }

    public void removeEntryListener(EntryListener<K, V> listener, K key) {
        ProxyHelper.check(listener);
        ProxyHelper.check(key);
        this.proxyHelper.doOp(ClusterOperation.REMOVE_LISTENER, key, null);
        this.client.getListenerManager().getEntryListenerManager().removeEntryListener(this.name, key, listener);
    }

    public void lock(K key) {
        ProxyHelper.check(key);
        this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK, key, -1L, null);
    }

    public boolean tryLock(K key) {
        ProxyHelper.check(key);
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK, key, 0L, null);
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) {
        ProxyHelper.check(key);
        ProxyHelper.checkTime(time, timeunit);
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK, key, time, timeunit);
    }

    private Object doLock(ClusterOperation operation, Object key, long timeout, TimeUnit timeUnit) {
        Packet request = this.proxyHelper.prepareRequest(operation, key, (Object)timeUnit);
        request.setTimeout(timeout);
        Packet response = this.proxyHelper.callAndGetResult(request);
        return this.proxyHelper.getValue(response);
    }

    public void unlock(K key) {
        ProxyHelper.check(key);
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_UNLOCK, key, null);
    }

    public boolean lockMap(long time, TimeUnit timeunit) {
        ProxyHelper.checkTime(time, timeunit);
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK_MAP, null, time, timeunit);
    }

    public void unlockMap() {
        this.doLock(ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP, null, -1L, null);
    }

    public boolean put(K key, V value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT_MULTI, key, value);
    }

    public Collection get(Object key) {
        ProxyHelper.check(key);
        return (Collection)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_GET, key, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, key, value);
    }

    public Collection remove(Object key) {
        ProxyHelper.check(key);
        return (Collection)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE_MULTI, key, null);
    }

    public Set keySet() {
        Collection collection = this.proxyHelper.keys(null);
        LightKeySet set = new LightKeySet(this, new HashSet(collection));
        return set;
    }

    public Collection values() {
        Set set = this.entrySet();
        return new ValueCollection(this, set);
    }

    public Set entrySet() {
        Set keySet = this.keySet();
        return new LightMultiMapEntrySet(keySet, this, this.getInstanceType());
    }

    public boolean containsKey(Object key) {
        ProxyHelper.check(key);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS, key, null);
    }

    @Override
    public boolean containsValue(Object value) {
        ProxyHelper.check(value);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, null, value);
    }

    public boolean containsEntry(Object key, Object value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, key, value);
    }

    @Override
    public int size() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_SIZE, null, null);
    }

    public void clear() {
        Set keys = this.keySet();
        for (Object key : keys) {
            this.remove(key);
        }
    }

    public int valueCount(Object key) {
        ProxyHelper.check(key);
        return (Integer)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_VALUE_COUNT, key, null);
    }

    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.MULTIMAP;
    }

    public void destroy() {
        this.proxyHelper.destroy();
    }

    public Object getId() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o instanceof MultiMap && o != null) {
            return this.getName().equals(((MultiMap)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

