/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.impl.EntryListenerManager;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ItemListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListenerManager {
    final Map<ItemListener, EntryListener> itemListener2EntryListener = new ConcurrentHashMap<ItemListener, EntryListener>();
    private final EntryListenerManager entryListenerManager;

    public ItemListenerManager(EntryListenerManager entryListenerManager) {
        this.entryListenerManager = entryListenerManager;
    }

    public <E, V> void registerItemListener(String name, final ItemListener<E> itemListener) {
        EntryListener e = new EntryListener<E, V>(){

            public void entryAdded(EntryEvent<E, V> event) {
                itemListener.itemAdded(event.getKey());
            }

            public void entryEvicted(EntryEvent<E, V> event) {
            }

            public void entryRemoved(EntryEvent<E, V> event) {
                itemListener.itemRemoved(event.getKey());
            }

            public void entryUpdated(EntryEvent<E, V> event) {
            }
        };
        this.entryListenerManager.registerEntryListener(name, null, e);
        this.itemListener2EntryListener.put(itemListener, e);
    }

    public void removeItemListener(String name, ItemListener itemListener) {
        EntryListener entryListener = this.itemListener2EntryListener.remove(itemListener);
        this.entryListenerManager.removeEntryListener(name, null, entryListener);
    }
}

