/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.impl.GroupProperties;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.FastByteArrayInputStream;
import com.hazelcast.nio.FastByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Serializer {
    private static final byte SERIALIZER_TYPE_DATA = 0;
    private static final byte SERIALIZER_TYPE_OBJECT = 1;
    private static final byte SERIALIZER_TYPE_BYTE_ARRAY = 2;
    private static final byte SERIALIZER_TYPE_INTEGER = 3;
    private static final byte SERIALIZER_TYPE_LONG = 4;
    private static final byte SERIALIZER_TYPE_CLASS = 5;
    private static final byte SERIALIZER_TYPE_STRING = 6;
    private static final byte SERIALIZER_TYPE_DATE = 7;
    private static final byte SERIALIZER_TYPE_BIG_INTEGER = 8;
    private static final boolean gzipEnabled = GroupProperties.SERIALIZER_GZIP_ENABLED.getBoolean();

    public static byte[] toByte(Object object) {
        FastByteArrayOutputStream dos = new FastByteArrayOutputStream();
        dos.reset();
        if (object == null) {
            return new byte[0];
        }
        try {
            if (object instanceof DataSerializable) {
                dos.writeByte(0);
                dos.writeUTF(object.getClass().getName().replaceFirst("com.hazelcast.client", "com.hazelcast"));
                ((DataSerializable)object).writeData((DataOutput)dos);
            } else if (object instanceof String) {
                String string = (String)object;
                dos.writeByte(6);
                dos.writeUTF(string);
            } else if (object instanceof byte[]) {
                byte[] bytes = (byte[])object;
                dos.writeByte(2);
                dos.writeInt(bytes.length);
                dos.write(bytes);
            } else if (object instanceof Integer) {
                dos.writeByte(3);
                dos.writeInt(((Integer)object).intValue());
            } else if (object instanceof Long) {
                dos.writeByte(4);
                dos.writeLong(((Long)object).longValue());
            } else if (object instanceof Class) {
                dos.writeByte(5);
                dos.writeUTF(((Class)object).getName());
            } else if (object instanceof Date) {
                dos.writeByte(7);
                dos.writeLong(((Date)object).getTime());
            } else if (object instanceof BigInteger) {
                dos.writeByte(8);
                byte[] bytes = ((BigInteger)object).toByteArray();
                dos.writeInt(bytes.length);
                dos.write(bytes);
            } else {
                dos.writeByte(1);
                if (gzipEnabled) {
                    Serializer.writeGZip((OutputStream)dos, object);
                } else {
                    Serializer.writeNormal((OutputStream)dos, object);
                }
            }
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return dos.toByteArray();
    }

    public static Object toObject(byte[] bytes) {
        FastByteArrayInputStream dis = new FastByteArrayInputStream(bytes);
        int type = dis.read();
        try {
            if (type == 0) {
                String className = dis.readUTF();
                if (className.equals("com.hazelcast.impl.Keys")) {
                    className = "com.hazelcast.client.impl.CollectionWrapper";
                } else if (className.equals("com.hazelcast.impl.CMap$Values")) {
                    className = "com.hazelcast.client.impl.Values";
                }
                DataSerializable data = (DataSerializable)Class.forName(className).newInstance();
                data.readData((DataInput)dis);
                return data;
            }
            if (type == 6) {
                return dis.readUTF();
            }
            if (type == 2) {
                int size = dis.readInt();
                byte[] b = new byte[size];
                int redSize = dis.read(b);
                if (size != 0 && size != redSize) {
                    throw new RuntimeException("Couldn't read all of the data Size: " + size + ", But I red:" + redSize);
                }
                return b;
            }
            if (type == 3) {
                return dis.readInt();
            }
            if (type == 4) {
                return dis.readLong();
            }
            if (type == 5) {
                return Class.forName(dis.readUTF());
            }
            if (type == 7) {
                return new Date(dis.readLong());
            }
            if (type == 8) {
                byte[] intBytes = new byte[dis.readInt()];
                dis.read(intBytes);
                return new BigInteger(intBytes);
            }
            if (type == 1) {
                if (gzipEnabled) {
                    return Serializer.readGZip((InputStream)dis);
                }
                return Serializer.readNormal((InputStream)dis);
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void writeGZip(OutputStream out, Object object) throws IOException {
        BufferedOutputStream zos = new BufferedOutputStream(new GZIPOutputStream(out));
        ObjectOutputStream os = new ObjectOutputStream(zos);
        os.writeObject(object);
        os.flush();
        os.close();
    }

    private static void writeNormal(OutputStream out, Object object) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(out);
        os.writeObject(object);
        os.flush();
        os.close();
    }

    private static Object readGZip(InputStream is) throws Exception {
        BufferedInputStream zis = new BufferedInputStream(new GZIPInputStream(is));
        ObjectInputStream in = new ObjectInputStream(zis);
        Object o = in.readObject();
        in.close();
        return o;
    }

    private static Object readNormal(InputStream is) throws Exception {
        ObjectInputStream in = new ObjectInputStream(is);
        Object o = in.readObject();
        in.close();
        return o;
    }
}

