/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.Serializer;
import com.hazelcast.client.cluster.Bind;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.nio.Address;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManager
implements MembershipListener {
    private volatile Connection currentConnection;
    private final AtomicInteger connectionIdGenerator = new AtomicInteger(-1);
    private final List<InetSocketAddress> clusterMembers = new CopyOnWriteArrayList<InetSocketAddress>();
    private final Logger logger = Logger.getLogger(this.getClass().toString());
    private final HazelcastClient client;

    public ConnectionManager(HazelcastClient client, InetSocketAddress[] clusterMembers, boolean shuffle) {
        this.client = client;
        this.clusterMembers.addAll(Arrays.asList(clusterMembers));
        if (shuffle) {
            Collections.shuffle(this.clusterMembers);
        }
    }

    public ConnectionManager(HazelcastClient client, InetSocketAddress address) {
        this.client = client;
        this.clusterMembers.add(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws IOException {
        if (this.currentConnection == null) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                Connection connection;
                if (this.currentConnection == null && (connection = this.searchForAvailableConnection()) != null) {
                    this.logger.fine("Client is connecting to " + connection);
                    this.bind(connection);
                    this.currentConnection = connection;
                }
            }
        }
        return this.currentConnection;
    }

    public synchronized void destroyConnection(Connection connection) {
        if (this.currentConnection != null && this.currentConnection.getVersion() == connection.getVersion()) {
            this.logger.warning("Connection to " + this.currentConnection + " is lost");
            this.currentConnection = null;
        }
    }

    private void bind(Connection connection) throws IOException {
        Bind b = null;
        try {
            b = new Bind(new Address(connection.getAddress().getHostName(), connection.getSocket().getLocalPort()));
        }
        catch (UnknownHostException e) {
            this.logger.warning(e.getMessage() + " while creating the bind package.");
        }
        Packet bind = new Packet();
        bind.set("remotelyProcess", ClusterOperation.REMOTELY_PROCESS, Serializer.toByte(null), Serializer.toByte(b));
        Call cBind = ProxyHelper.createCall(bind);
        this.client.getOutRunnable().callMap.put(cBind.getId(), cBind);
        this.client.getOutRunnable().writer.write(connection, bind);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void popAndPush(List<InetSocketAddress> clusterMembers) {
        InetSocketAddress address = clusterMembers.remove(0);
        clusterMembers.add(address);
    }

    private Connection searchForAvailableConnection() {
        Connection connection = null;
        this.popAndPush(this.clusterMembers);
        for (int counter = this.clusterMembers.size(); counter > 0; --counter) {
            try {
                connection = this.getNextConnection();
                break;
            }
            catch (Exception e) {
                this.popAndPush(this.clusterMembers);
                continue;
            }
        }
        return connection;
    }

    private Connection getNextConnection() {
        InetSocketAddress address = this.clusterMembers.get(0);
        Connection connection = new Connection(address, this.connectionIdGenerator.incrementAndGet());
        return connection;
    }

    public synchronized void memberAdded(MembershipEvent membershipEvent) {
        if (!this.clusterMembers.contains(membershipEvent.getMember().getInetSocketAddress())) {
            this.clusterMembers.add(membershipEvent.getMember().getInetSocketAddress());
        }
    }

    public synchronized void memberRemoved(MembershipEvent membershipEvent) {
        this.clusterMembers.remove(membershipEvent.getMember().getInetSocketAddress());
    }

    public synchronized void updateMembers() {
        Set members = this.client.getCluster().getMembers();
        this.clusterMembers.clear();
        for (Member member : members) {
            this.clusterMembers.add(member.getInetSocketAddress());
        }
    }
}

