/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.Connection;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.IORunnable;
import com.hazelcast.client.Packet;
import com.hazelcast.client.PacketReader;
import com.hazelcast.impl.ClusterOperation;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InRunnable
extends IORunnable
implements Runnable {
    final PacketReader reader;
    final Logger logger = Logger.getLogger(this.getClass().getName());
    Connection connection = null;

    public InRunnable(HazelcastClient client, Map<Long, Call> calls, PacketReader reader) {
        super(client, calls);
        this.reader = reader;
    }

    @Override
    protected void customRun() {
        try {
            Connection oldConnection = this.connection;
            this.connection = this.client.connectionManager.getConnection();
            if (this.restoredConnection(oldConnection, this.connection)) {
                this.onDisconnect(oldConnection);
            }
            if (this.connection == null) {
                this.interruptWaitingCalls();
                Thread.sleep(1000L);
            } else {
                Packet packet = this.reader.readPacket(this.connection);
                Call call = (Call)this.callMap.remove(packet.getCallId());
                if (call != null) {
                    call.setResponse(packet);
                } else {
                    if (packet.getOperation().equals((Object)ClusterOperation.EVENT)) {
                        this.client.listenerManager.enqueue(packet);
                    }
                    if (packet.getCallId() != -1L) {
                        throw new RuntimeException("In Thread can not handle: " + packet.getOperation() + " : " + packet.getCallId());
                    }
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            this.logger.info("InRunnable got an exception:" + e.toString());
            this.client.connectionManager.destroyConnection(this.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                try {
                    Connection connection = this.client.connectionManager.getConnection();
                    if (connection != null) {
                        connection.getSocket().close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

