/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientExecutionManagerCallback;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureProxy<T>
implements Future<T> {
    final Callable<T> callable;
    final ProxyHelper proxyHelper;
    private volatile boolean isDone = false;
    private ClientExecutionManagerCallback callback;
    private volatile T result;
    private volatile ExecutionException exception = null;

    public FutureProxy(ProxyHelper proxyHelper, Callable<T> callable) {
        this.proxyHelper = proxyHelper;
        this.callable = callable;
    }

    @Override
    public boolean cancel(boolean b) {
        return this.callback.cancel(b);
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.callback.get();
        return this.handleResult(this.result);
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        this.callback.get(l, timeUnit);
        return this.handleResult(this.result);
    }

    private T handleResult(Object result) throws ExecutionException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.isDone) {
            return this.result;
        }
        if (result instanceof ExecutionException) {
            this.exception = (ExecutionException)result;
            throw this.exception;
        }
        this.isDone = true;
        this.result = result;
        return this.result;
    }

    public void enqueue(Packet packet) {
        this.callback.offer(packet);
    }

    public void setCallback(ClientExecutionManagerCallback callback) {
        this.callback = callback;
    }
}

