/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.impl.ExecutionManagerCallback;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class ClientExecutionManagerCallback
implements ExecutionManagerCallback {
    final BlockingQueue<Packet> queue = new LinkedBlockingQueue<Packet>();

    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    public void get() throws InterruptedException, ExecutionException {
        this.get(-1L, null);
    }

    public abstract void get(long var1, TimeUnit var3) throws InterruptedException, ExecutionException;

    protected Object handleResult(Packet packet) throws ExecutionException {
        return Serializer.toObject(packet.getValue());
    }

    public void offer(Packet packet) {
        this.queue.offer(packet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultipleResultClientExecutionManagerCallBack
    extends ClientExecutionManagerCallback {
        private volatile Collection<Object> result;
        private volatile Iterator<Object> it;

        @Override
        public void get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException {
        }

        @Override
        protected Collection<Object> handleResult(Packet packet) throws ExecutionException {
            Object o = Serializer.toObject(packet.getValue());
            if (o instanceof ExecutionException) {
                ExecutionException e = (ExecutionException)o;
                throw e;
            }
            if (o instanceof Collection) {
                return (Collection)o;
            }
            throw new RuntimeException("Should return collection, but returned object is: " + o);
        }
    }

    public static class SingleResultClientExecutionManagerCallBack
    extends ClientExecutionManagerCallback {
        private volatile Object result;
        private volatile boolean done = false;

        public void get(long l, TimeUnit timeUnit) throws InterruptedException {
        }
    }
}

