/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Packet;
import com.hazelcast.core.Member;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Call {
    private final long id;
    private final Packet request;
    private final BlockingQueue<Object> responseQueue = new LinkedBlockingQueue<Object>();

    public Call(long id, Packet request) {
        this.id = id;
        this.request = request;
        this.request.setCallId(id);
    }

    public Packet getRequest() {
        return this.request;
    }

    public long getId() {
        return this.id;
    }

    public Object getResponse() {
        try {
            return this.handleResponse(this.responseQueue.take());
        }
        catch (InterruptedException ignored) {
            return null;
        }
    }

    public Object handleResponse(Object response) {
        if (response == null) {
            return null;
        }
        if (response instanceof RuntimeException) {
            throw (RuntimeException)response;
        }
        return response;
    }

    public Object getResponse(long timeout, TimeUnit unit) {
        try {
            return this.handleResponse(this.responseQueue.poll(timeout, unit));
        }
        catch (InterruptedException ignored) {
            return null;
        }
    }

    public void onDisconnect(Member member) {
    }

    public void setResponse(Object response) {
        this.responseQueue.offer(response);
    }

    public String toString() {
        return "Call [" + this.id + "] operation=" + this.request.getOperation();
    }
}

