/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientRunnable;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.Packet;
import com.hazelcast.client.Serializer;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceEvent;
import com.hazelcast.core.InstanceListener;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.impl.BaseManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager
extends ClientRunnable {
    private final HazelcastClient client;
    private final BlockingQueue<Call> listenerCalls = new LinkedBlockingQueue<Call>();
    final BlockingQueue<Packet> queue = new LinkedBlockingQueue<Packet>();
    public final InstanceListenerManager instanceListenerManager;
    public final MembershipListenerManager membershipListenerManager;
    public final MessageListenerManager messageListenerManager;
    public final EntryListenerManager entryListenerManager;
    public final ItemListenerManager itemListenerManager;

    public ListenerManager(HazelcastClient hazelcastClient) {
        this.client = hazelcastClient;
        this.instanceListenerManager = new InstanceListenerManager(this.client);
        this.membershipListenerManager = new MembershipListenerManager(this.client);
        this.messageListenerManager = new MessageListenerManager();
        this.entryListenerManager = new EntryListenerManager();
        this.itemListenerManager = new ItemListenerManager(this.entryListenerManager);
    }

    public void enqueue(Packet packet) {
        try {
            this.queue.put(packet);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void addListenerCall(Call call) {
        this.listenerCalls.add(call);
    }

    public BlockingQueue<Call> getListenerCalls() {
        return this.listenerCalls;
    }

    @Override
    protected void customRun() throws InterruptedException {
        try {
            Packet packet = this.queue.poll(100L, TimeUnit.MILLISECONDS);
            if (packet == null) {
                return;
            }
            if (packet.getName() == null) {
                Object eventType = Serializer.toObject(packet.getValue());
                if (eventType instanceof InstanceEvent.InstanceEventType) {
                    this.instanceListenerManager.notifyInstanceListeners(packet);
                } else {
                    this.membershipListenerManager.notifyMembershipListeners(packet);
                }
            } else if (BaseManager.getInstanceType((String)packet.getName()).equals((Object)Instance.InstanceType.TOPIC)) {
                this.messageListenerManager.notifyMessageListeners(packet);
            } else {
                this.entryListenerManager.notifyEntryListeners(packet);
            }
        }
        catch (InterruptedException ine) {
            throw ine;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class InstanceListenerManager {
        private final List<InstanceListener> instanceListeners = new CopyOnWriteArrayList<InstanceListener>();
        private final HazelcastClient client;

        public InstanceListenerManager(HazelcastClient client) {
            this.client = client;
        }

        public void registerInstanceListener(InstanceListener listener) {
            this.instanceListeners.add(listener);
        }

        public void removeInstanceListener(InstanceListener instanceListener) {
            this.instanceListeners.remove(instanceListener);
        }

        public synchronized boolean noInstanceListenerRegistered() {
            return this.instanceListeners.isEmpty();
        }

        public void notifyInstanceListeners(Packet packet) {
            String id = (String)Serializer.toObject(packet.getKey());
            InstanceEvent.InstanceEventType instanceEventType = (InstanceEvent.InstanceEventType)Serializer.toObject(packet.getValue());
            InstanceEvent event = new InstanceEvent(instanceEventType, (Instance)this.client.getClientProxy(id));
            for (InstanceListener listener : this.instanceListeners) {
                if (InstanceEvent.InstanceEventType.CREATED.equals((Object)event.getEventType())) {
                    listener.instanceCreated(event);
                    continue;
                }
                if (!InstanceEvent.InstanceEventType.DESTROYED.equals((Object)event.getEventType())) continue;
                listener.instanceDestroyed(event);
            }
        }
    }

    public static class MembershipListenerManager {
        private final List<MembershipListener> memberShipListeners = new CopyOnWriteArrayList<MembershipListener>();
        private final HazelcastClient client;

        public MembershipListenerManager(HazelcastClient client) {
            this.client = client;
        }

        public void registerMembershipListener(MembershipListener listener) {
            this.memberShipListeners.add(listener);
        }

        public void removeMembershipListener(MembershipListener listener) {
            this.memberShipListeners.remove(listener);
        }

        public synchronized boolean noMembershipListenerRegistered() {
            return this.memberShipListeners.isEmpty();
        }

        public void notifyMembershipListeners(Packet packet) {
            Member member = (Member)Serializer.toObject(packet.getKey());
            Integer type = (Integer)Serializer.toObject(packet.getValue());
            MembershipEvent event = new MembershipEvent(this.client.getCluster(), member, type.intValue());
            if (type.equals(1)) {
                for (MembershipListener membershipListener : this.memberShipListeners) {
                    membershipListener.memberAdded(event);
                }
            } else {
                for (MembershipListener membershipListener : this.memberShipListeners) {
                    membershipListener.memberRemoved(event);
                }
            }
        }
    }

    public static class MessageListenerManager {
        private final Map<String, List<MessageListener<Object>>> messageListeners = new ConcurrentHashMap<String, List<MessageListener<Object>>>();

        public synchronized void registerMessageListener(String name, MessageListener messageListener) {
            if (!this.messageListeners.containsKey(name)) {
                this.messageListeners.put(name, new ArrayList());
            }
            this.messageListeners.get(name).add((MessageListener<Object>)messageListener);
        }

        public synchronized void removeMessageListener(String name, MessageListener messageListener) {
            if (!this.messageListeners.containsKey(name)) {
                return;
            }
            this.messageListeners.get(name).remove(messageListener);
            if (this.messageListeners.get(name).size() == 0) {
                this.messageListeners.remove(name);
            }
        }

        public synchronized boolean noMessageListenerRegistered(String name) {
            if (!this.messageListeners.containsKey(name)) {
                return true;
            }
            return this.messageListeners.get(name).size() <= 0;
        }

        public void notifyMessageListeners(Packet packet) {
            List<MessageListener<Object>> list = this.messageListeners.get(packet.getName());
            if (list != null) {
                for (MessageListener<Object> messageListener : list) {
                    messageListener.onMessage(Serializer.toObject(packet.getKey()));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ItemListenerManager {
        final Map<ItemListener, EntryListener> itemListener2EntryListener = new ConcurrentHashMap<ItemListener, EntryListener>();
        private final EntryListenerManager entryListenerManager;

        public ItemListenerManager(EntryListenerManager entryListenerManager) {
            this.entryListenerManager = entryListenerManager;
        }

        public synchronized <E, V> void registerItemListener(String name, final ItemListener<E> itemListener) {
            EntryListener e = new EntryListener<E, V>(){

                public void entryAdded(EntryEvent<E, V> event) {
                    itemListener.itemAdded(event.getKey());
                }

                public void entryEvicted(EntryEvent<E, V> event) {
                }

                public void entryRemoved(EntryEvent<E, V> event) {
                    itemListener.itemRemoved(event.getKey());
                }

                public void entryUpdated(EntryEvent<E, V> event) {
                }
            };
            this.entryListenerManager.registerEntryListener(name, null, e);
            this.itemListener2EntryListener.put(itemListener, e);
        }

        public synchronized void removeItemListener(String name, ItemListener itemListener) {
            EntryListener entryListener = this.itemListener2EntryListener.remove(itemListener);
            this.entryListenerManager.removeEntryListener(name, null, entryListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntryListenerManager {
        private final Map<String, Map<Object, List<EntryListener<?, ?>>>> entryListeners = new ConcurrentHashMap();

        public synchronized void registerEntryListener(String name, Object key, EntryListener<?, ?> entryListener) {
            if (!this.entryListeners.containsKey(name)) {
                this.entryListeners.put(name, new HashMap());
            }
            if (!this.entryListeners.get(name).containsKey(key)) {
                this.entryListeners.get(name).put(key, new ArrayList());
            }
            this.entryListeners.get(name).get(key).add(entryListener);
        }

        public synchronized void removeEntryListener(String name, Object key, EntryListener<?, ?> entryListener) {
            Map<Object, List<EntryListener<?, ?>>> m = this.entryListeners.get(name);
            if (m != null) {
                List<EntryListener<?, ?>> list = m.get(key);
                if (list != null) {
                    list.remove(entryListener);
                    if (m.get(key).size() == 0) {
                        m.remove(key);
                    }
                }
                if (m.size() == 0) {
                    this.entryListeners.remove(name);
                }
            }
        }

        public synchronized boolean noEntryListenerRegistered(Object key, String name) {
            return this.entryListeners.get(name) == null || this.entryListeners.get(name).get(key) == null || this.entryListeners.get(name).get(key).size() <= 0;
        }

        public void notifyEntryListeners(Packet packet) {
            EntryEvent event = new EntryEvent((Object)packet.getName(), (int)packet.getLongValue(), Serializer.toObject(packet.getKey()), Serializer.toObject(packet.getValue()));
            String name = event.getName();
            Object key = event.getKey();
            if (this.entryListeners.get(name) != null) {
                this.notifyEntryListeners(event, (Collection)this.entryListeners.get(name).get(null));
                this.notifyEntryListeners(event, (Collection)this.entryListeners.get(name).get(key));
            }
        }

        private void notifyEntryListeners(EntryEvent event, Collection<EntryListener<?, ?>> collection) {
            if (collection == null) {
                return;
            }
            switch (event.getEventType()) {
                case ADDED: {
                    for (EntryListener<?, ?> entryListener : collection) {
                        entryListener.entryAdded(event);
                    }
                    break;
                }
                case UPDATED: {
                    for (EntryListener<?, ?> entryListener : collection) {
                        entryListener.entryUpdated(event);
                    }
                    break;
                }
                case REMOVED: {
                    for (EntryListener<?, ?> entryListener : collection) {
                        entryListener.entryRemoved(event);
                    }
                    break;
                }
                case EVICTED: {
                    for (EntryListener<?, ?> entryListener : collection) {
                        entryListener.entryEvicted(event);
                    }
                    break;
                }
            }
        }
    }
}

