/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.PNCounterMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class PNCounterAddCodec {
    public static final PNCounterMessageType REQUEST_TYPE = PNCounterMessageType.PNCOUNTER_ADD;
    public static final int RESPONSE_TYPE = 103;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, long delta, boolean getBeforeUpdate) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, delta, getBeforeUpdate);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("PNCounter.add");
        clientMessage.set(name);
        clientMessage.set(delta);
        clientMessage.set(getBeforeUpdate);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        long delta = 0L;
        parameters.delta = delta = clientMessage.getLong();
        boolean getBeforeUpdate = false;
        parameters.getBeforeUpdate = getBeforeUpdate = clientMessage.getBoolean();
        return parameters;
    }

    public static ClientMessage encodeResponse(long response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(103);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        if (clientMessage.isComplete()) {
            return parameters;
        }
        long response = 0L;
        parameters.response = response = clientMessage.getLong();
        return parameters;
    }

    public static class ResponseParameters {
        public long response;

        public static int calculateDataSize(long response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize += 8;
        }
    }

    public static class RequestParameters {
        public static final PNCounterMessageType TYPE = REQUEST_TYPE;
        public String name;
        public long delta;
        public boolean getBeforeUpdate;

        public static int calculateDataSize(String name, long delta, boolean getBeforeUpdate) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize((String)name);
            dataSize += 8;
            return ++dataSize;
        }
    }
}

