/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapAddNearCacheEntryListenerCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_ADDNEARCACHEENTRYLISTENER;
    public static final int RESPONSE_TYPE = 104;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, int listenerFlags, boolean localOnly) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, listenerFlags, localOnly);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(listenerFlags);
        clientMessage.set(localOnly);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        int listenerFlags = 0;
        parameters.listenerFlags = listenerFlags = clientMessage.getInt();
        boolean localOnly = false;
        parameters.localOnly = localOnly = clientMessage.getBoolean();
        return parameters;
    }

    public static ClientMessage encodeResponse(String response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode((int)requiredDataSize);
        clientMessage.setMessageType(104);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        String response = null;
        parameters.response = response = clientMessage.getStringUtf8();
        return parameters;
    }

    public static ClientMessage encodeIMapInvalidationEvent(Data key) {
        int dataSize = ClientMessage.HEADER_SIZE;
        ++dataSize;
        if (key != null) {
            dataSize += ParameterUtil.calculateDataSize((Data)key);
        }
        ClientMessage clientMessage = ClientMessage.createForEncode((int)dataSize);
        clientMessage.setMessageType(215);
        clientMessage.addFlag((short)1);
        if (key == null) {
            boolean key_isNull = true;
            clientMessage.set(key_isNull);
        } else {
            boolean key_isNull = false;
            clientMessage.set(key_isNull);
            clientMessage.set(key);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ClientMessage encodeIMapBatchInvalidationEvent(Collection<Data> keys) {
        int dataSize = ClientMessage.HEADER_SIZE;
        dataSize += 4;
        for (Data keys_item : keys) {
            dataSize += ParameterUtil.calculateDataSize((Data)keys_item);
        }
        ClientMessage clientMessage = ClientMessage.createForEncode((int)dataSize);
        clientMessage.setMessageType(216);
        clientMessage.addFlag((short)1);
        clientMessage.set(keys.size());
        for (Data keys_item : keys) {
            clientMessage.set(keys_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            if (messageType == 215) {
                boolean key_isNull;
                boolean messageFinished = false;
                Data key = null;
                if (!messageFinished && !(key_isNull = clientMessage.getBoolean())) {
                    key = clientMessage.getData();
                }
                this.handle(key);
                return;
            }
            if (messageType == 216) {
                boolean messageFinished = false;
                ArrayList<Data> keys = null;
                if (!messageFinished) {
                    int keys_size = clientMessage.getInt();
                    keys = new ArrayList<Data>(keys_size);
                    for (int keys_index = 0; keys_index < keys_size; ++keys_index) {
                        Data keys_item = null;
                        keys_item = clientMessage.getData();
                        keys.add(keys_item);
                    }
                }
                this.handle(keys);
                return;
            }
            Logger.getLogger(super.getClass()).warning("Unknown message type received on event handler :" + clientMessage.getMessageType());
        }

        public abstract void handle(Data var1);

        public abstract void handle(Collection<Data> var1);
    }

    public static class ResponseParameters {
        public String response;

        public static int calculateDataSize(String response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return dataSize += ParameterUtil.calculateDataSize((String)response);
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public int listenerFlags;
        public boolean localOnly;

        public static int calculateDataSize(String name, int listenerFlags, boolean localOnly) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateDataSize((String)name);
            dataSize += 4;
            return ++dataSize;
        }
    }
}

