/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerToKeyWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddIndexCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddInterceptorCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapClearCodec;
import com.hazelcast.client.impl.protocol.codec.MapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.MapDeleteCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntriesWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntriesWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.MapEvictAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapEvictCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnAllKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapFlushCodec;
import com.hazelcast.client.impl.protocol.codec.MapForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetAsyncCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetEntryViewCodec;
import com.hazelcast.client.impl.protocol.codec.MapIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.MapIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapLoadAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapLoadGivenKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapLockCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutAsyncCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutTransientCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveAsyncCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveInterceptorCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemovePartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.MapReplaceIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.MapSetCodec;
import com.hazelcast.client.impl.protocol.codec.MapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.MapSubmitToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryPutCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesWithPredicateCodec;
import com.hazelcast.client.nearcache.ClientHeapNearCache;
import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerRemoveCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private final String name;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();
    private volatile ClientHeapNearCache<Data> nearCache;
    private static final ClientMessageDecoder getAsyncResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapGetAsyncCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder putAsyncResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapPutAsyncCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder removeAsyncResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapRemoveAsyncCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder submitToKeyResponseDecoder = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapSubmitToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };

    public ClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public boolean containsKey(Object key) {
        Object cached;
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            return !cached.equals(ClientNearCache.NULL_OBJECT);
        }
        ClientMessage message = MapContainsKeyCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage result = (ClientMessage)this.invoke(message, keyData);
        MapContainsKeyCodec.ResponseParameters resultParameters = MapContainsKeyCodec.decodeResponse((ClientMessage)result);
        return resultParameters.response;
    }

    public boolean containsValue(Object value) {
        Preconditions.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = MapContainsValueCodec.encodeRequest((String)this.name, (Data)valueData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapContainsValueCodec.ResponseParameters resultParameters = MapContainsValueCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public V get(Object key) {
        Object cached;
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            if (cached.equals(ClientHeapNearCache.NULL_OBJECT)) {
                return null;
            }
            return (V)cached;
        }
        ClientMessage request = MapGetCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapGetCodec.ResponseParameters resultParameters = MapGetCodec.decodeResponse((ClientMessage)response);
        Object result = this.toObject(resultParameters.response);
        if (this.nearCache != null) {
            this.nearCache.put(keyData, result);
        }
        return (V)result;
    }

    public V put(K key, V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V remove(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapRemoveCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapRemoveCodec.ResponseParameters resultParameters = MapRemoveCodec.decodeResponse((ClientMessage)response);
        return (V)this.toObject(resultParameters.response);
    }

    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapRemoveIfSameCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapRemoveIfSameCodec.ResponseParameters resultParameters = MapRemoveIfSameCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void delete(Object key) {
        Preconditions.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapDeleteCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    public void flush() {
        ClientMessage request = MapFlushCodec.encodeRequest((String)this.name);
        this.invoke(request);
    }

    public Future<V> getAsync(K key) {
        Object cached;
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        this.initNearCache();
        final Data keyData = this.toData(key);
        SerializationService serializationService = this.getContext().getSerializationService();
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null && !ClientNearCache.NULL_OBJECT.equals(cached)) {
            return new CompletedFuture(serializationService, cached, this.getContext().getExecutionService().getAsyncExecutor());
        }
        ClientMessage request = MapGetAsyncCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            ClientDelegatingFuture delegatingFuture = new ClientDelegatingFuture(future, serializationService, getAsyncResponseDecoder);
            if (this.nearCache != null) {
                delegatingFuture.andThenInternal(new ExecutionCallback<Data>(){

                    public void onResponse(Data response) {
                        if (ClientMapProxy.this.nearCache != null) {
                            ClientMapProxy.this.nearCache.put(keyData, response);
                        }
                    }

                    public void onFailure(Throwable t) {
                    }
                });
            }
            return delegatingFuture;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private ClientInvocationFuture invokeOnKeyOwner(ClientMessage request, Data keyData) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, partitionId);
        return clientInvocation.invoke();
    }

    public Future<V> putAsync(K key, V value) {
        return this.putAsync(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public Future<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapPutAsyncCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getContext().getSerializationService(), putAsyncResponseDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future<V> removeAsync(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapRemoveAsyncCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getContext().getSerializationService(), removeAsyncResponseDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapTryRemoveCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)timeunit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapTryRemoveCodec.ResponseParameters resultParameters = MapTryRemoveCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapTryPutCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)timeunit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapTryPutCodec.ResponseParameters resultParameters = MapTryPutCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapPutCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapPutCodec.ResponseParameters resultParameters = MapPutCodec.decodeResponse((ClientMessage)response);
        return (V)this.toObject(resultParameters.response);
    }

    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapPutTransientCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        this.invoke(request, keyData);
    }

    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapPutIfAbsentCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        ClientMessage result = (ClientMessage)this.invoke(request, keyData);
        MapPutIfAbsentCodec.ResponseParameters resultParameters = MapPutIfAbsentCodec.decodeResponse((ClientMessage)result);
        return (V)this.toObject(resultParameters.response);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(oldValue, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(newValue, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapReplaceIfSameCodec.encodeRequest((String)this.name, (Data)keyData, (Data)oldValueData, (Data)newValueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapReplaceIfSameCodec.ResponseParameters resultParameters = MapReplaceIfSameCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public V replace(K key, V value) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapReplaceCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapReplaceCodec.ResponseParameters resultParameters = MapReplaceCodec.decodeResponse((ClientMessage)response);
        return (V)this.toObject(resultParameters.response);
    }

    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        ClientMessage request = MapSetCodec.encodeRequest((String)this.name, (Data)keyData, (Data)valueData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(ttl, timeunit));
        this.invoke(request, keyData);
    }

    public void lock(K key) {
        this.lock(key, -1L, TimeUnit.MILLISECONDS);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapLockCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(leaseTime, timeUnit));
        this.invoke(request, keyData);
    }

    public boolean isLocked(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapIsLockedCodec.encodeRequest((String)this.name, (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapIsLockedCodec.ResponseParameters resultParameters = MapIsLockedCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapTryLockCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId(), (long)this.getTimeInMillis(time, timeunit));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapTryLockCodec.ResponseParameters resultParameters = MapTryLockCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void unlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapUnlockCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapForceUnlockCodec.encodeRequest((String)this.name, (Data)keyData);
        this.invoke(request, keyData);
    }

    public String addLocalEntryListener(MapListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public String addInterceptor(MapInterceptor interceptor) {
        Data data = this.toData(interceptor);
        ClientMessage request = MapAddInterceptorCodec.encodeRequest((String)this.name, (Data)data);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapAddInterceptorCodec.ResponseParameters resultParameters = MapAddInterceptorCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void removeInterceptor(String id) {
        ClientMessage request = MapRemoveInterceptorCodec.encodeRequest((String)this.name, (String)id);
        this.invoke(request);
    }

    public String addEntryListener(MapListener listener, boolean includeValue) {
        ClientMessage request = MapAddEntryListenerCodec.encodeRequest((String)this.name, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, handler, responseDecoder);
    }

    public String addEntryListener(EntryListener listener, boolean includeValue) {
        ClientMessage request = MapAddEntryListenerCodec.encodeRequest((String)this.name, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, handler, responseDecoder);
    }

    public boolean removeEntryListener(String registrationId) {
        return this.stopListening(registrationId, new ListenerRemoveCodec(){

            @Override
            public ClientMessage encodeRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        });
    }

    public String addPartitionLostListener(MapPartitionLostListener listener) {
        ClientMessage request = MapAddPartitionLostListenerCodec.encodeRequest((String)this.name);
        ClientMapPartitionLostEventHandler handler = new ClientMapPartitionLostEventHandler(listener);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddPartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, handler, responseDecoder);
    }

    public boolean removePartitionLostListener(String registrationId) {
        return this.stopListening(registrationId, new ListenerRemoveCodec(){

            @Override
            public ClientMessage encodeRequest(String realRegistrationId) {
                return MapRemovePartitionLostListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeResponse(ClientMessage clientMessage) {
                return MapRemovePartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        });
    }

    public String addEntryListener(MapListener listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        ClientMessage request = MapAddEntryListenerToKeyCodec.encodeRequest((String)this.name, (Data)keyData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, keyData, handler, responseDecoder);
    }

    public String addEntryListener(EntryListener listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        ClientMessage request = MapAddEntryListenerToKeyCodec.encodeRequest((String)this.name, (Data)keyData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, keyData, handler, responseDecoder);
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        ClientMessage request = MapAddEntryListenerToKeyWithPredicateCodec.encodeRequest((String)this.name, (Data)keyData, (Data)predicateData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddEntryListenerToKeyWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, keyData, handler, responseDecoder);
    }

    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        ClientMessage request = MapAddEntryListenerToKeyWithPredicateCodec.encodeRequest((String)this.name, (Data)keyData, (Data)predicateData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddEntryListenerToKeyWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, keyData, handler, responseDecoder);
    }

    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Data predicateData = this.toData(predicate);
        ClientMessage request = MapAddEntryListenerWithPredicateCodec.encodeRequest((String)this.name, (Data)predicateData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddEntryListenerWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, null, handler, responseDecoder);
    }

    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Data predicateData = this.toData(predicate);
        ClientMessage request = MapAddEntryListenerWithPredicateCodec.encodeRequest((String)this.name, (Data)predicateData, (boolean)includeValue);
        EventHandler<ClientMessage> handler = this.createHandler(listener, includeValue);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)MapAddEntryListenerWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, null, handler, responseDecoder);
    }

    public EntryView<K, V> getEntryView(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapGetEntryViewCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapGetEntryViewCodec.ResponseParameters parameters = MapGetEntryViewCodec.decodeResponse((ClientMessage)response);
        SimpleEntryView entryView = new SimpleEntryView();
        SimpleEntryView dataEntryView = parameters.dataEntryView;
        if (dataEntryView == null) {
            return null;
        }
        entryView.setKey(this.toObject(dataEntryView.getKey()));
        entryView.setValue(this.toObject(dataEntryView.getValue()));
        entryView.setCost(dataEntryView.getCost());
        entryView.setCreationTime(dataEntryView.getCreationTime());
        entryView.setExpirationTime(dataEntryView.getExpirationTime());
        entryView.setHits(dataEntryView.getHits());
        entryView.setLastAccessTime(dataEntryView.getLastAccessTime());
        entryView.setLastStoredTime(dataEntryView.getLastStoredTime());
        entryView.setLastUpdateTime(dataEntryView.getLastUpdateTime());
        entryView.setVersion(dataEntryView.getVersion());
        entryView.setEvictionCriteriaNumber(dataEntryView.getEvictionCriteriaNumber());
        entryView.setTtl(dataEntryView.getTtl());
        return entryView;
    }

    public boolean evict(K key) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapEvictCodec.encodeRequest((String)this.name, (Data)keyData, (long)ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapEvictCodec.ResponseParameters resultParameters = MapEvictCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void evictAll() {
        this.invalidateNearCache();
        ClientMessage request = MapEvictAllCodec.encodeRequest((String)this.name);
        this.invoke(request);
    }

    public void loadAll(boolean replaceExistingValues) {
        if (replaceExistingValues) {
            this.invalidateNearCache();
        }
        ClientMessage request = MapLoadAllCodec.encodeRequest((String)this.name, (boolean)replaceExistingValues);
        this.invoke(request);
    }

    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        Preconditions.checkNotNull(keys, (String)"Parameter keys should not be null.");
        if (keys.isEmpty()) {
            return;
        }
        List<Data> dataKeys = this.convertKeysToData(keys);
        if (replaceExistingValues) {
            this.invalidateNearCache(dataKeys);
        }
        ClientMessage request = MapLoadGivenKeysCodec.encodeRequest((String)this.name, dataKeys, (boolean)replaceExistingValues);
        this.invoke(request);
    }

    private <K> List<Data> convertKeysToData(Set<K> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Data> dataKeys = new ArrayList<Data>(keys.size());
        for (K key : keys) {
            Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
            Data dataKey = this.toData(key);
            dataKeys.add(dataKey);
        }
        return dataKeys;
    }

    public Set<K> keySet() {
        ClientMessage request = MapKeySetCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapKeySetCodec.ResponseParameters resultParameters = MapKeySetCodec.decodeResponse((ClientMessage)response);
        Collection result = resultParameters.list;
        HashSet keySet = new HashSet(result.size());
        for (Data data : result) {
            Object key = this.toObject(data);
            keySet.add(key);
        }
        return keySet;
    }

    public Map<K, V> getAll(Set<K> keys) {
        this.initNearCache();
        HashSet<Data> keySet = new HashSet<Data>(keys.size());
        HashMap result = new HashMap();
        for (Object key : keys) {
            keySet.add(this.toData(key));
        }
        if (this.nearCache != null) {
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Object key;
                key = (Data)iterator.next();
                Object cached = this.nearCache.get((Data)key);
                if (cached == null || ClientHeapNearCache.NULL_OBJECT.equals(cached)) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
        }
        if (keySet.isEmpty()) {
            return result;
        }
        ClientMessage request = MapGetAllCodec.encodeRequest((String)this.name, keySet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapGetAllCodec.ResponseParameters resultParameters = MapGetAllCodec.decodeResponse((ClientMessage)response);
        for (Map.Entry entry : resultParameters.map.entrySet()) {
            Object value = this.toObject(entry.getValue());
            Object key = this.toObject(entry.getKey());
            result.put(key, value);
            if (this.nearCache == null) continue;
            this.nearCache.put((Data)entry.getKey(), value);
        }
        return result;
    }

    public Collection<V> values() {
        ClientMessage request = MapValuesCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapValuesCodec.ResponseParameters resultParameters = MapValuesCodec.decodeResponse((ClientMessage)response);
        Collection collectionData = resultParameters.list;
        ArrayList collection = new ArrayList(collectionData.size());
        for (Data data : collectionData) {
            Object value = this.toObject(data);
            collection.add(value);
        }
        return collection;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = MapEntrySetCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapEntrySetCodec.ResponseParameters resultParameters = MapEntrySetCodec.decodeResponse((ClientMessage)response);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry entry : resultParameters.map.entrySet()) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    public Set<K> keySet(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            return this.keySetWithPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapKeySetWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapKeySetWithPredicateCodec.ResponseParameters resultParameters = MapKeySetWithPredicateCodec.decodeResponse((ClientMessage)response);
        HashSet keySet = new HashSet();
        for (Data o : resultParameters.list) {
            Object key = this.toObject(o);
            keySet.add(key);
        }
        return keySet;
    }

    private Set<K> keySetWithPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.KEY);
        ClientMessage request = MapKeySetWithPagingPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapKeySetWithPagingPredicateCodec.ResponseParameters resultParameters = MapKeySetWithPagingPredicateCodec.decodeResponse((ClientMessage)response);
        ArrayList resultList = new ArrayList();
        for (Map.Entry entry : resultParameters.map.entrySet()) {
            Object key = this.toObject(entry.getKey());
            resultList.add(new AbstractMap.SimpleImmutableEntry(key, null));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, (PagingPredicate)pagingPredicate, (IterationType)IterationType.KEY);
    }

    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            return this.entrySetWithPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapEntriesWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapEntriesWithPredicateCodec.ResponseParameters resultParameters = MapEntriesWithPredicateCodec.decodeResponse((ClientMessage)response);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>(resultParameters.map.size());
        for (Map.Entry entry : resultParameters.map.entrySet()) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    public Set<Map.Entry<K, V>> entrySetWithPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.ENTRY);
        ClientMessage request = MapEntriesWithPagingPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapEntriesWithPagingPredicateCodec.ResponseParameters resultParameters = MapEntriesWithPagingPredicateCodec.decodeResponse((ClientMessage)response);
        ArrayList resultList = new ArrayList();
        for (Map.Entry entry : resultParameters.map.entrySet()) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            resultList.add(new AbstractMap.SimpleEntry(key, value));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, (PagingPredicate)pagingPredicate, (IterationType)IterationType.ENTRY);
    }

    public Collection<V> values(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            return this.valuesForPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapValuesWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapValuesWithPredicateCodec.ResponseParameters resultParameters = MapValuesWithPredicateCodec.decodeResponse((ClientMessage)response);
        Collection result = resultParameters.list;
        ArrayList values = new ArrayList(result.size());
        for (Data data : result) {
            Object value = this.toObject(data);
            values.add(value);
        }
        return values;
    }

    private Collection<V> valuesForPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.VALUE);
        ClientMessage request = MapValuesWithPagingPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapValuesWithPagingPredicateCodec.ResponseParameters resultParameters = MapValuesWithPagingPredicateCodec.decodeResponse((ClientMessage)response);
        ArrayList resultList = new ArrayList(resultParameters.map.size());
        for (Map.Entry entry : resultParameters.map.entrySet()) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            resultList.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, (PagingPredicate)pagingPredicate, (IterationType)IterationType.VALUE);
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public void addIndex(String attribute, boolean ordered) {
        ClientMessage request = MapAddIndexCodec.encodeRequest((String)this.name, (String)attribute, (boolean)ordered);
        this.invoke(request);
    }

    public LocalMapStats getLocalMapStats() {
        this.initNearCache();
        LocalMapStatsImpl localMapStats = new LocalMapStatsImpl();
        if (this.nearCache != null) {
            localMapStats.setNearCacheStats(this.nearCache.getNearCacheStats());
        }
        return localMapStats;
    }

    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapExecuteOnKeyCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), (Data)keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return this.toObject(MapExecuteOnKeyCodec.decodeResponse((ClientMessage)response).response);
    }

    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapSubmitToKeyCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), (Data)keyData);
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            SerializationService serializationService = this.getContext().getSerializationService();
            ClientDelegatingFuture clientDelegatingFuture = new ClientDelegatingFuture(future, serializationService, submitToKeyResponseDecoder);
            clientDelegatingFuture.andThen(callback);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Future submitToKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapSubmitToKeyCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), (Data)keyData);
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getContext().getSerializationService(), submitToKeyResponseDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        ClientMessage request = MapExecuteOnAllKeysCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapExecuteOnAllKeysCodec.ResponseParameters resultParameters = MapExecuteOnAllKeysCodec.decodeResponse((ClientMessage)response);
        HashMap result = new HashMap();
        for (Map.Entry entry : resultParameters.map.entrySet()) {
            Object key = this.toObject(entry.getKey());
            result.put(key, this.toObject(entry.getValue()));
        }
        return result;
    }

    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        ClientMessage request = MapExecuteWithPredicateCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), (Data)this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapExecuteWithPredicateCodec.ResponseParameters resultParameters = MapExecuteWithPredicateCodec.decodeResponse((ClientMessage)response);
        HashMap result = new HashMap();
        for (Map.Entry entry : resultParameters.map.entrySet()) {
            Object key = this.toObject(entry.getKey());
            result.put(key, this.toObject(entry.getValue()));
        }
        return result;
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-map-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull((Object)jobTracker, (String)"jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMap((IMap)this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        HashSet<Data> dataKeys = new HashSet<Data>(keys.size());
        for (K key : keys) {
            dataKeys.add(this.toData(key));
        }
        ClientMessage request = MapExecuteOnKeysCodec.encodeRequest((String)this.name, (Data)this.toData(entryProcessor), dataKeys);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapExecuteOnKeysCodec.ResponseParameters resultParameters = MapExecuteOnKeysCodec.decodeResponse((ClientMessage)response);
        HashMap result = new HashMap();
        for (Map.Entry entry : resultParameters.map.entrySet()) {
            Object key = this.toObject(entry.getKey());
            result.put(key, this.toObject(entry.getValue()));
        }
        return result;
    }

    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    public int size() {
        ClientMessage request = MapSizeCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapSizeCodec.ResponseParameters resultParameters = MapSizeCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean isEmpty() {
        ClientMessage request = MapIsEmptyCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapIsEmptyCodec.ResponseParameters resultParameters = MapIsEmptyCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        HashMap<Data, Data> map = new HashMap<Data, Data>();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            Data keyData = this.toData(entry.getKey());
            this.invalidateNearCache(keyData);
            map.put(keyData, this.toData(entry.getValue()));
        }
        ClientMessage request = MapPutAllCodec.encodeRequest((String)this.name, map);
        this.invoke(request);
    }

    public void clear() {
        ClientMessage request = MapClearCodec.encodeRequest((String)this.name);
        this.invalidateNearCache();
        this.invoke(request);
    }

    @Override
    protected void onDestroy() {
        this.destroyNearCache();
    }

    private void destroyNearCache() {
        if (this.nearCache != null) {
            this.removeNearCacheInvalidationListener();
            this.nearCache.destroy();
        }
    }

    @Override
    protected void onShutdown() {
        this.destroyNearCache();
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<ClientMessage> createHandler(Object listener, boolean includeValue) {
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter((Object)listener);
        return new ClientMapEventHandler(listenerAdaptor, includeValue);
    }

    private void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.invalidate(key);
        }
    }

    private void invalidateNearCache() {
        if (this.nearCache != null) {
            this.nearCache.clear();
        }
    }

    private void invalidateNearCache(Collection<Data> keys) {
        if (this.nearCache != null) {
            if (keys == null || keys.isEmpty()) {
                return;
            }
            for (Data key : keys) {
                this.nearCache.invalidate(key);
            }
        }
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
            if (nearCacheConfig == null) {
                return;
            }
            this.nearCache = new ClientHeapNearCache(this.name, this.getContext(), nearCacheConfig);
            if (this.nearCache.isInvalidateOnChange()) {
                this.addNearCacheInvalidateListener();
            }
        }
    }

    private void addNearCacheInvalidateListener() {
        try {
            ClientMessage request = MapAddNearCacheEntryListenerCodec.encodeRequest((String)this.name, (boolean)false);
            ClientMapAddNearCacheEventHandler handler = new ClientMapAddNearCacheEventHandler();
            String registrationId = this.getContext().getListenerService().startListening(request, null, handler, new ClientMessageDecoder(){

                @Override
                public <T> T decodeClientMessage(ClientMessage clientMessage) {
                    return (T)MapAddNearCacheEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
                }
            });
            this.nearCache.setId(registrationId);
        }
        catch (Exception e) {
            Logger.getLogger(ClientHeapNearCache.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", (Throwable)e);
        }
    }

    private void removeNearCacheInvalidationListener() {
        if (this.nearCache != null && this.nearCache.getId() != null) {
            String registrationId = this.nearCache.getId();
            ClientListenerService listenerService = this.getContext().getListenerService();
            listenerService.stopListening(registrationId, new ListenerRemoveCodec(){

                @Override
                public ClientMessage encodeRequest(String realRegistrationId) {
                    return MapRemoveEntryListenerCodec.encodeRequest((String)ClientMapProxy.this.name, (String)realRegistrationId);
                }

                @Override
                public boolean decodeResponse(ClientMessage clientMessage) {
                    return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
                }
            });
        }
    }

    public String toString() {
        return "IMap{name='" + this.getName() + '\'' + '}';
    }

    private class ClientMapAddNearCacheEventHandler
    extends MapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private ClientMapAddNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            ClientMapProxy.this.invalidateNearCache();
        }

        @Override
        public void onListenerRegister() {
            ClientMapProxy.this.invalidateNearCache();
        }

        public void handle(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            EntryEventType entryEventType = EntryEventType.getByType((int)eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case MERGED: {
                    ClientMapProxy.this.nearCache.remove(key);
                    break;
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    ClientMapProxy.this.nearCache.clear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + entryEventType);
                }
            }
        }
    }

    private class ClientMapPartitionLostEventHandler
    extends MapAddPartitionLostListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private MapPartitionLostListener listener;

        public ClientMapPartitionLostEventHandler(MapPartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }

        public void handle(int partitionId, String uuid) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(uuid);
            this.listener.partitionLost(new MapPartitionLostEvent((Object)ClientMapProxy.this.name, member, -1, partitionId));
        }
    }

    private class ClientMapEventHandler
    extends MapAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ListenerAdapter listenerAdapter;
        private final boolean includeValue;

        public ClientMapEventHandler(ListenerAdapter listenerAdapter, boolean includeValue) {
            this.listenerAdapter = listenerAdapter;
            this.includeValue = includeValue;
        }

        public void handle(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(uuid);
            IMapEvent iMapEvent = this.createIMapEvent(key, value, oldValue, mergingValue, eventType, numberOfAffectedEntries, member);
            this.listenerAdapter.onEvent(iMapEvent);
        }

        private IMapEvent createIMapEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, int numberOfAffectedEntries, Member member) {
            EntryEvent iMapEvent;
            EntryEventType entryEventType = EntryEventType.getByType((int)eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case MERGED: {
                    iMapEvent = this.createEntryEvent(key, value, oldValue, mergingValue, eventType, member);
                    break;
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    iMapEvent = this.createMapEvent(eventType, numberOfAffectedEntries, member);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + entryEventType);
                }
            }
            return iMapEvent;
        }

        private MapEvent createMapEvent(int eventType, int numberOfAffectedEntries, Member member) {
            return new MapEvent((Object)ClientMapProxy.this.name, member, eventType, numberOfAffectedEntries);
        }

        private EntryEvent<K, V> createEntryEvent(Data keyData, Data valueData, Data oldValueData, Data mergingValueData, int eventType, Member member) {
            return new DataAwareEntryEvent(member, eventType, ClientMapProxy.this.name, keyData, valueData, oldValueData, mergingValueData, ClientMapProxy.this.getContext().getSerializationService());
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

