/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.util.EmptyStatement;
import java.io.IOException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientInvocation
implements Runnable {
    protected static final int UNASSIGNED_PARTITION = -1;
    private static final long RETRY_WAIT_TIME_IN_SECONDS = 1L;
    private static final ILogger LOGGER = Logger.getLogger(ClientInvocation.class);
    protected ClientInvocationFuture clientInvocationFuture;
    private final LifecycleService lifecycleService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private final ClientMessage clientMessage;
    private final long retryCountLimit;
    private final int heartBeatInterval;
    private final AtomicInteger reSendCount = new AtomicInteger();
    private final Address address;
    private final int partitionId;
    private final Connection connection;
    private volatile ClientConnection sendConnection;
    private boolean bypassHeartbeatCheck;

    protected ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, int partitionId, Address address, Connection connection) {
        this.lifecycleService = client.getLifecycleService();
        this.invocationService = client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.clientMessage = clientMessage;
        this.partitionId = partitionId;
        this.address = address;
        this.connection = connection;
        ClientProperties clientProperties = client.getClientProperties();
        int waitTime = clientProperties.getInvocationTimeoutSeconds().getInteger();
        long retryTimeoutInSeconds = waitTime > 0 ? (long)waitTime : (long)Integer.parseInt("120");
        this.clientInvocationFuture = new ClientInvocationFuture(this, client, clientMessage);
        this.retryCountLimit = retryTimeoutInSeconds / 1L;
        int interval = clientProperties.getHeartbeatInterval().getInteger();
        this.heartBeatInterval = interval > 0 ? interval : Integer.parseInt("5000");
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage) {
        this(client, clientMessage, -1, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, int partitionId) {
        this(client, clientMessage, partitionId, null, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Address address) {
        this(client, clientMessage, -1, address, null);
    }

    public ClientInvocation(HazelcastClientInstanceImpl client, ClientMessage clientMessage, Connection connection) {
        this(client, clientMessage, -1, null, connection);
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ClientMessage getClientMessage() {
        return this.clientMessage;
    }

    public ClientInvocationFuture invoke() {
        if (this.clientMessage == null) {
            throw new IllegalStateException("Request can not be null");
        }
        try {
            this.invokeOnSelection();
        }
        catch (Exception e) {
            this.notifyException(e);
        }
        return this.clientInvocationFuture;
    }

    private void invokeOnSelection() throws IOException {
        if (this.isBindToSingleConnection()) {
            this.invocationService.invokeOnConnection(this, (ClientConnection)this.connection);
        } else if (this.partitionId != -1) {
            this.invocationService.invokeOnPartitionOwner(this, this.partitionId);
        } else if (this.address != null) {
            this.invocationService.invokeOnTarget(this, this.address);
        } else {
            this.invocationService.invokeOnRandomTarget(this);
        }
    }

    @Override
    public void run() {
        try {
            this.invoke();
        }
        catch (Throwable e) {
            this.onException(e);
        }
    }

    protected void onException(Throwable e) {
        this.clientInvocationFuture.setResponse(e);
    }

    public void notify(ClientMessage clientMessage) {
        if (clientMessage == null) {
            throw new IllegalArgumentException("response can't be null");
        }
        this.clientInvocationFuture.setResponse(clientMessage);
    }

    public void notifyException(Throwable exception) {
        if (!this.lifecycleService.isRunning()) {
            this.clientInvocationFuture.setResponse(new HazelcastClientNotActiveException(exception.getMessage()));
            return;
        }
        if ((exception instanceof IOException || exception instanceof HazelcastInstanceNotActiveException || exception instanceof AuthenticationException) && this.handleRetry()) {
            return;
        }
        if (exception instanceof RetryableHazelcastException && (this.clientMessage.isRetryable() || this.invocationService.isRedoOperation()) && this.handleRetry()) {
            return;
        }
        this.clientInvocationFuture.setResponse(exception);
    }

    private boolean handleRetry() {
        if (this.isBindToSingleConnection()) {
            return false;
        }
        if (!this.shouldRetry()) {
            return false;
        }
        this.beforeRetry();
        try {
            this.sleep();
            ((ClientExecutionServiceImpl)this.executionService).executeInternal(this);
        }
        catch (RejectedExecutionException e) {
            if (LOGGER.isFinestEnabled()) {
                LOGGER.finest("Retry could not be scheduled ", (Throwable)e);
            }
            this.clientInvocationFuture.setResponse(e);
        }
        return true;
    }

    protected void beforeRetry() {
    }

    protected boolean shouldRetry() {
        return (long)this.reSendCount.incrementAndGet() < this.retryCountLimit;
    }

    private void sleep() {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        catch (InterruptedException ignored) {
            EmptyStatement.ignore((Throwable)ignored);
        }
    }

    private boolean isBindToSingleConnection() {
        return this.connection != null;
    }

    boolean isConnectionHealthy(long elapsed) {
        if (elapsed >= (long)this.heartBeatInterval) {
            if (this.sendConnection != null) {
                return this.sendConnection.isHeartBeating();
            }
            return true;
        }
        return true;
    }

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public boolean shouldBypassHeartbeatCheck() {
        return this.bypassHeartbeatCheck;
    }

    public void setBypassHeartbeatCheck(boolean bypassHeartbeatCheck) {
        this.bypassHeartbeatCheck = bypassHeartbeatCheck;
    }

    public void setSendConnection(ClientConnection connection) {
        this.sendConnection = connection;
    }

    public ClientConnection getSendConnection() {
        return this.sendConnection;
    }

    public boolean isInvoked() {
        return this.sendConnection != null;
    }
}

