/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientRemovePartitionLostListenerCodec;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerRemoveCodec;
import com.hazelcast.core.Member;
import com.hazelcast.core.MigrationListener;
import com.hazelcast.core.Partition;
import com.hazelcast.core.PartitionService;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.PartitionLostEvent;
import com.hazelcast.partition.PartitionLostListener;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class PartitionServiceProxy
implements PartitionService {
    private final ClientPartitionService partitionService;
    private final ClientListenerService listenerService;
    private final HazelcastClientInstanceImpl client;
    private final Random random = new Random();

    public PartitionServiceProxy(ClientPartitionService partitionService, ClientListenerService listenerService, HazelcastClientInstanceImpl client) {
        this.partitionService = partitionService;
        this.listenerService = listenerService;
        this.client = client;
    }

    public String randomPartitionKey() {
        return Integer.toString(this.random.nextInt(this.partitionService.getPartitionCount()));
    }

    public Set<Partition> getPartitions() {
        int partitionCount = this.partitionService.getPartitionCount();
        LinkedHashSet<Partition> partitions = new LinkedHashSet<Partition>(partitionCount);
        for (int i = 0; i < partitionCount; ++i) {
            Partition partition = this.partitionService.getPartition(i);
            partitions.add(partition);
        }
        return partitions;
    }

    public Partition getPartition(Object key) {
        int partitionId = this.partitionService.getPartitionId(key);
        return this.partitionService.getPartition(partitionId);
    }

    public String addMigrationListener(MigrationListener migrationListener) {
        throw new UnsupportedOperationException();
    }

    public boolean removeMigrationListener(String registrationId) {
        throw new UnsupportedOperationException();
    }

    public String addPartitionLostListener(PartitionLostListener partitionLostListener) {
        ClientMessage request = ClientAddPartitionLostListenerCodec.encodeRequest();
        ClientPartitionLostEventHandler handler = new ClientPartitionLostEventHandler(partitionLostListener);
        return this.listenerService.startListening(request, null, handler, new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)ClientAddPartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        });
    }

    public boolean removePartitionLostListener(String registrationId) {
        boolean result = this.listenerService.stopListening(registrationId, new ListenerRemoveCodec(){

            @Override
            public ClientMessage encodeRequest(String realRegistrationId) {
                return ClientRemovePartitionLostListenerCodec.encodeRequest((String)realRegistrationId);
            }

            @Override
            public boolean decodeResponse(ClientMessage clientMessage) {
                return ClientRemovePartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        });
        return result;
    }

    public boolean isClusterSafe() {
        throw new UnsupportedOperationException();
    }

    public boolean isMemberSafe(Member member) {
        throw new UnsupportedOperationException();
    }

    public boolean isLocalMemberSafe() {
        throw new UnsupportedOperationException();
    }

    public boolean forceLocalMemberToBeSafe(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public boolean drain(long timeout, TimeUnit timeunit) {
        return true;
    }

    private static class ClientPartitionLostEventHandler
    extends ClientAddPartitionLostListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private PartitionLostListener listener;

        public ClientPartitionLostEventHandler(PartitionLostListener listener) {
            this.listener = listener;
        }

        public void handle(int partitionId, int lostBackupCount, Address source) {
            this.listener.partitionLost(new PartitionLostEvent(partitionId, lostBackupCount, source));
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

