/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ListAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddCodec;
import com.hazelcast.client.impl.protocol.codec.SetAddListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetClearCodec;
import com.hazelcast.client.impl.protocol.codec.SetCompareAndRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetCompareAndRetainAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetContainsAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetContainsCodec;
import com.hazelcast.client.impl.protocol.codec.SetGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.SetIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.SetRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.SetRemoveListenerCodec;
import com.hazelcast.client.impl.protocol.codec.SetSizeCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerRemoveCodec;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class ClientSetProxy<E>
extends ClientProxy
implements ISet<E> {
    private final String name;

    public ClientSetProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public int size() {
        ClientMessage request = SetSizeCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetSizeCodec.ResponseParameters resultParameters = SetSizeCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean isEmpty() {
        ClientMessage request = SetIsEmptyCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetIsEmptyCodec.ResponseParameters resultParameters = SetIsEmptyCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean contains(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = SetContainsCodec.encodeRequest((String)this.name, (Data)value);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetContainsCodec.ResponseParameters resultParameters = SetContainsCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public Iterator<E> iterator() {
        return Collections.unmodifiableCollection(this.getAll()).iterator();
    }

    public Object[] toArray() {
        return this.getAll().toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.getAll().toArray(a);
    }

    public boolean add(E e) {
        this.throwExceptionIfNull(e);
        Data element = this.toData(e);
        ClientMessage request = SetAddCodec.encodeRequest((String)this.name, (Data)element);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetAddCodec.ResponseParameters resultParameters = SetAddCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean remove(Object o) {
        this.throwExceptionIfNull(o);
        Data value = this.toData(o);
        ClientMessage request = SetRemoveCodec.encodeRequest((String)this.name, (Data)value);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetRemoveCodec.ResponseParameters resultParameters = SetRemoveCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean containsAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>(c.size());
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = SetContainsAllCodec.encodeRequest((String)this.name, valueSet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetContainsAllCodec.ResponseParameters resultParameters = SetContainsAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean addAll(Collection<? extends E> c) {
        this.throwExceptionIfNull(c);
        ArrayList<Data> valueList = new ArrayList<Data>(c.size());
        for (E e : c) {
            this.throwExceptionIfNull(e);
            valueList.add(this.toData(e));
        }
        ClientMessage request = SetAddAllCodec.encodeRequest((String)this.name, valueList);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetAddAllCodec.ResponseParameters resultParameters = SetAddAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean removeAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = SetCompareAndRemoveAllCodec.encodeRequest((String)this.name, valueSet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetCompareAndRemoveAllCodec.ResponseParameters resultParameters = SetCompareAndRemoveAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public boolean retainAll(Collection<?> c) {
        this.throwExceptionIfNull(c);
        HashSet<Data> valueSet = new HashSet<Data>();
        for (Object o : c) {
            this.throwExceptionIfNull(o);
            valueSet.add(this.toData(o));
        }
        ClientMessage request = SetCompareAndRetainAllCodec.encodeRequest((String)this.name, valueSet);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetCompareAndRetainAllCodec.ResponseParameters resultParameters = SetCompareAndRetainAllCodec.decodeResponse((ClientMessage)response);
        return resultParameters.response;
    }

    public void clear() {
        ClientMessage request = SetClearCodec.encodeRequest((String)this.name);
        this.invoke(request);
    }

    public String addItemListener(ItemListener<E> listener, boolean includeValue) {
        ClientMessage request = SetAddListenerCodec.encodeRequest((String)this.name, (boolean)includeValue);
        ItemEventHandler eventHandler = new ItemEventHandler(includeValue, listener);
        ClientMessageDecoder responseDecoder = new ClientMessageDecoder(){

            @Override
            public <T> T decodeClientMessage(ClientMessage clientMessage) {
                return (T)SetAddListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
        return this.listen(request, this.getPartitionKey(), eventHandler, responseDecoder);
    }

    public boolean removeItemListener(String registrationId) {
        return this.stopListening(registrationId, new ListenerRemoveCodec(){

            @Override
            public ClientMessage encodeRequest(String realRegistrationId) {
                return SetRemoveListenerCodec.encodeRequest((String)ClientSetProxy.this.name, (String)realRegistrationId);
            }

            @Override
            public boolean decodeResponse(ClientMessage clientMessage) {
                return SetRemoveListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        });
    }

    private Collection<E> getAll() {
        ClientMessage request = SetGetAllCodec.encodeRequest((String)this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        SetGetAllCodec.ResponseParameters resultParameters = SetGetAllCodec.decodeResponse((ClientMessage)response);
        Collection resultCollection = resultParameters.list;
        ArrayList list = new ArrayList(resultCollection.size());
        for (Data value : resultCollection) {
            list.add(this.toObject(value));
        }
        return list;
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getPartitionKey());
    }

    public String toString() {
        return "ISet{name='" + this.getName() + '\'' + '}';
    }

    private class ItemEventHandler
    extends ListAddListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final boolean includeValue;
        private final ItemListener<E> listener;

        public ItemEventHandler(boolean includeValue, ItemListener<E> listener) {
            this.includeValue = includeValue;
            this.listener = listener;
        }

        public void handle(Data dataItem, String uuid, int eventType) {
            SerializationService serializationService = ClientSetProxy.this.getContext().getSerializationService();
            ClientClusterService clusterService = ClientSetProxy.this.getContext().getClusterService();
            Object item = this.includeValue ? serializationService.toObject((Object)dataItem) : null;
            Member member = clusterService.getMember(uuid);
            ItemEvent itemEvent = new ItemEvent(ClientSetProxy.this.name, ItemEventType.getByType((int)eventType), item, member);
            if (eventType == ItemEventType.ADDED.getType()) {
                this.listener.itemAdded(itemEvent);
            } else {
                this.listener.itemRemoved(itemEvent);
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

