/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapReduceCancelCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForCustomCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForListCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForMapCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForMultiMapCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceForSetCodec;
import com.hazelcast.client.impl.protocol.codec.MapReduceJobProcessInformationCodec;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.Logger;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobProcessInformation;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyPredicate;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.TopologyChangedStrategy;
import com.hazelcast.mapreduce.TrackableJob;
import com.hazelcast.mapreduce.impl.AbstractJob;
import com.hazelcast.mapreduce.impl.ListKeyValueSource;
import com.hazelcast.mapreduce.impl.MapKeyValueSource;
import com.hazelcast.mapreduce.impl.MultiMapKeyValueSource;
import com.hazelcast.mapreduce.impl.SetKeyValueSource;
import com.hazelcast.mapreduce.impl.task.TransferableJobProcessInformation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.AbstractCompletableFuture;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.UuidUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientMapReduceProxy
extends ClientProxy
implements JobTracker {
    private final ConcurrentMap<String, ClientTrackableJob> trackableJobs = new ConcurrentHashMap<String, ClientTrackableJob>();

    public ClientMapReduceProxy(String serviceName, String objectName) {
        super(serviceName, objectName);
    }

    @Override
    protected void onDestroy() {
        for (ClientTrackableJob trackableJob : this.trackableJobs.values()) {
            trackableJob.completableFuture.cancel(false);
        }
    }

    public <K, V> Job<K, V> newJob(KeyValueSource<K, V> source) {
        return new ClientJob<K, V>(this.getName(), source);
    }

    public <V> TrackableJob<V> getTrackableJob(String jobId) {
        return (TrackableJob)this.trackableJobs.get(jobId);
    }

    public String toString() {
        return "JobTracker{name='" + this.getName() + '\'' + '}';
    }

    private ClientMessage invoke(ClientMessage request, String jobId) throws Exception {
        ClientTrackableJob trackableJob = (ClientTrackableJob)this.trackableJobs.get(jobId);
        if (trackableJob != null) {
            Address runningMember = trackableJob.jobOwner;
            ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, runningMember);
            ClientInvocationFuture future = clientInvocation.invoke();
            return future.get();
        }
        return null;
    }

    private Map toObjectMap(ClientMessage res) {
        SerializationService serializationService = this.getContext().getSerializationService();
        Map map = MapReduceForCustomCodec.decodeResponse((ClientMessage)res).map;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (Map.Entry entry : map.entrySet()) {
            Object key = serializationService.toObject(entry.getKey());
            Object value = serializationService.toObject(entry.getValue());
            hashMap.put(key, value);
        }
        return hashMap;
    }

    private ClientMessage getRequest(String name, String jobId, Collection keys, KeyPredicate predicate, Mapper mapper, CombinerFactory combinerFactory, ReducerFactory reducerFactory, KeyValueSource keyValueSource, int chunkSize, TopologyChangedStrategy topologyChangedStrategy) {
        MapKeyValueSource source;
        Data predicateData = this.toData(predicate);
        Data mapperData = this.toData(mapper);
        Data combinerFactoryData = this.toData(combinerFactory);
        Data reducerFactoryData = this.toData(reducerFactory);
        ArrayList<Data> list = null;
        if (keys != null) {
            list = new ArrayList<Data>(keys.size());
            for (Object key : keys) {
                list.add(this.toData(key));
            }
        }
        String topologyChangedStrategyName = null;
        if (topologyChangedStrategy != null) {
            topologyChangedStrategyName = topologyChangedStrategy.name();
        }
        if (keyValueSource instanceof MapKeyValueSource) {
            source = (MapKeyValueSource)keyValueSource;
            return MapReduceForMapCodec.encodeRequest((String)name, (String)jobId, (Data)predicateData, (Data)mapperData, (Data)combinerFactoryData, (Data)reducerFactoryData, (String)source.getMapName(), (int)chunkSize, list, (String)topologyChangedStrategyName);
        }
        if (keyValueSource instanceof ListKeyValueSource) {
            source = (ListKeyValueSource)keyValueSource;
            return MapReduceForListCodec.encodeRequest((String)name, (String)jobId, (Data)predicateData, (Data)mapperData, (Data)combinerFactoryData, (Data)reducerFactoryData, (String)source.getListName(), (int)chunkSize, list, (String)topologyChangedStrategyName);
        }
        if (keyValueSource instanceof SetKeyValueSource) {
            source = (SetKeyValueSource)keyValueSource;
            return MapReduceForSetCodec.encodeRequest((String)name, (String)jobId, (Data)predicateData, (Data)mapperData, (Data)combinerFactoryData, (Data)reducerFactoryData, (String)source.getSetName(), (int)chunkSize, list, (String)topologyChangedStrategyName);
        }
        if (keyValueSource instanceof MultiMapKeyValueSource) {
            source = (MultiMapKeyValueSource)keyValueSource;
            return MapReduceForMultiMapCodec.encodeRequest((String)name, (String)jobId, (Data)predicateData, (Data)mapperData, (Data)combinerFactoryData, (Data)reducerFactoryData, (String)source.getMultiMapName(), (int)chunkSize, list, (String)topologyChangedStrategyName);
        }
        return MapReduceForCustomCodec.encodeRequest((String)name, (String)jobId, (Data)predicateData, (Data)mapperData, (Data)combinerFactoryData, (Data)reducerFactoryData, (Data)this.toData(keyValueSource), (int)chunkSize, list, (String)topologyChangedStrategyName);
    }

    private final class ClientTrackableJob<V>
    implements TrackableJob<V> {
        private final String jobId;
        private final Address jobOwner;
        private final AbstractCompletableFuture<V> completableFuture;

        private ClientTrackableJob(String jobId, Address jobOwner, AbstractCompletableFuture<V> completableFuture) {
            this.jobId = jobId;
            this.jobOwner = jobOwner;
            this.completableFuture = completableFuture;
        }

        public JobTracker getJobTracker() {
            return ClientMapReduceProxy.this;
        }

        public String getName() {
            return ClientMapReduceProxy.this.getName();
        }

        public String getJobId() {
            return this.jobId;
        }

        public ICompletableFuture<V> getCompletableFuture() {
            return this.completableFuture;
        }

        public JobProcessInformation getJobProcessInformation() {
            try {
                ClientMessage request = MapReduceJobProcessInformationCodec.encodeRequest((String)this.getName(), (String)this.jobId);
                MapReduceJobProcessInformationCodec.ResponseParameters responseParameters = MapReduceJobProcessInformationCodec.decodeResponse((ClientMessage)ClientMapReduceProxy.this.invoke(request, this.jobId));
                return new TransferableJobProcessInformation(responseParameters.jobPartitionStates, responseParameters.processRecords);
            }
            catch (Exception ignore) {
                EmptyStatement.ignore((Throwable)ignore);
                return null;
            }
        }
    }

    private class ClientCompletableFuture<V>
    extends AbstractCompletableFuture<V>
    implements JobCompletableFuture<V> {
        private final String jobId;
        private final CountDownLatch latch;
        private volatile boolean cancelled;

        protected ClientCompletableFuture(String jobId) {
            super((Executor)ClientMapReduceProxy.this.getContext().getExecutionService().getAsyncExecutor(), Logger.getLogger(ClientCompletableFuture.class));
            this.jobId = jobId;
            this.latch = new CountDownLatch(1);
        }

        public String getJobId() {
            return this.jobId;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            try {
                ClientMessage request = MapReduceCancelCodec.encodeRequest((String)ClientMapReduceProxy.this.getName(), (String)this.jobId);
                ClientMessage response = ClientMapReduceProxy.this.invoke(request, this.jobId);
                this.cancelled = MapReduceCancelCodec.decodeResponse((ClientMessage)response).response;
            }
            catch (Exception ignore) {
                EmptyStatement.ignore((Throwable)ignore);
            }
            return this.cancelled;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setResult(Object result) {
            super.setResult(result);
            this.latch.countDown();
        }

        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Preconditions.isNotNull((Object)((Object)unit), (String)"unit");
            if (!this.latch.await(timeout, unit) || !this.isDone()) {
                throw new TimeoutException("timeout reached");
            }
            return (V)this.getResult();
        }
    }

    private class ClientJob<KeyIn, ValueIn>
    extends AbstractJob<KeyIn, ValueIn> {
        public ClientJob(String name, KeyValueSource<KeyIn, ValueIn> keyValueSource) {
            super(name, (JobTracker)ClientMapReduceProxy.this, keyValueSource);
        }

        protected <T> JobCompletableFuture<T> invoke(final Collator collator) {
            try {
                final String jobId = UuidUtil.buildRandomUuidString();
                ClientMessage request = ClientMapReduceProxy.this.getRequest(this.name, jobId, this.keys, this.predicate, this.mapper, this.combinerFactory, this.reducerFactory, this.keyValueSource, this.chunkSize, this.topologyChangedStrategy);
                final ClientCompletableFuture completableFuture = new ClientCompletableFuture(jobId);
                ClientInvocation clientInvocation = new ClientInvocation(ClientMapReduceProxy.this.getClient(), request);
                ClientInvocationFuture future = clientInvocation.invoke();
                future.andThen((ExecutionCallback<ClientMessage>)new ExecutionCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Object res) {
                        Map map = ClientMapReduceProxy.this.toObjectMap((ClientMessage)res);
                        Object response = map;
                        try {
                            if (collator != null) {
                                response = collator.collate(response.entrySet());
                            }
                        }
                        finally {
                            completableFuture.setResult(response);
                            ClientMapReduceProxy.this.trackableJobs.remove(jobId);
                        }
                    }

                    public void onFailure(Throwable throwable) {
                        Throwable t = throwable;
                        try {
                            if (t instanceof ExecutionException && t.getCause() instanceof CancellationException) {
                                t = t.getCause();
                            }
                            completableFuture.setResult(t);
                        }
                        finally {
                            ClientMapReduceProxy.this.trackableJobs.remove(jobId);
                        }
                    }
                });
                Address runningMember = clientInvocation.getSendConnection().getRemoteEndpoint();
                ClientMapReduceProxy.this.trackableJobs.putIfAbsent(jobId, new ClientTrackableJob(jobId, runningMember, completableFuture));
                return completableFuture;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

