/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchAwaitCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchCountDownCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchGetCountCodec;
import com.hazelcast.client.impl.protocol.codec.CountDownLatchTrySetCountCodec;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.nio.serialization.Data;
import java.util.concurrent.TimeUnit;

public class ClientCountDownLatchProxy
extends ClientProxy
implements ICountDownLatch {
    private volatile Data key;

    public ClientCountDownLatchProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        ClientMessage request = CountDownLatchAwaitCodec.encodeRequest((String)this.getName(), (long)this.getTimeInMillis(timeout, unit));
        CountDownLatchAwaitCodec.ResponseParameters resultParameters = CountDownLatchAwaitCodec.decodeResponse((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.response;
    }

    public void countDown() {
        ClientMessage request = CountDownLatchCountDownCodec.encodeRequest((String)this.getName());
        this.invoke(request);
    }

    public int getCount() {
        ClientMessage request = CountDownLatchGetCountCodec.encodeRequest((String)this.getName());
        CountDownLatchGetCountCodec.ResponseParameters resultParameters = CountDownLatchGetCountCodec.decodeResponse((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.response;
    }

    public boolean trySetCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count can't be negative");
        }
        ClientMessage request = CountDownLatchTrySetCountCodec.encodeRequest((String)this.getName(), (int)count);
        CountDownLatchTrySetCountCodec.ResponseParameters resultParameters = CountDownLatchTrySetCountCodec.decodeResponse((ClientMessage)((ClientMessage)this.invoke(request)));
        return resultParameters.response;
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.toData(this.getName());
        }
        return this.key;
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    protected <T> T invoke(ClientMessage req) {
        return super.invoke(req, this.getKey());
    }

    public String toString() {
        return "ICountDownLatch{name='" + this.getName() + '\'' + '}';
    }
}

