/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceCancelOnAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceCancelOnPartitionCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;

public final class ClientCancellableDelegatingFuture<V>
extends ClientDelegatingFuture<V> {
    private static final int INVOCATION_WAIT_TIMEOUT_SECONDS = 5;
    private final ClientContext context;
    private final String uuid;
    private final Address target;
    private final int partitionId;
    private final ILogger logger = Logger.getLogger(ClientCancellableDelegatingFuture.class);
    private volatile boolean cancelled;

    public ClientCancellableDelegatingFuture(ClientInvocationFuture future, ClientContext context, String uuid, Address target, int partitionId, V defaultValue) {
        super(future, context.getSerializationService(), defaultValue);
        this.context = context;
        this.uuid = uuid;
        this.target = target;
        this.partitionId = partitionId;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone() || this.cancelled) {
            return false;
        }
        this.waitForRequestToBeSend();
        ClientInvocationFuture f = this.invokeCancelRequest(mayInterruptIfRunning);
        try {
            boolean cancelSuccessful = ExecutorServiceCancelOnAddressCodec.decodeResponse((ClientMessage)f.get()).response;
            if (cancelSuccessful) {
                this.setError(new CancellationException());
                this.cancelled = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            this.setDone();
        }
    }

    private ClientInvocationFuture invokeCancelRequest(boolean mayInterruptIfRunning) {
        ClientInvocation clientInvocation;
        ClientMessage request;
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        if (this.target != null) {
            request = ExecutorServiceCancelOnAddressCodec.encodeRequest((String)this.uuid, (String)this.target.getHost(), (int)this.target.getPort(), (boolean)mayInterruptIfRunning);
            clientInvocation = new ClientInvocation(client, request, this.target);
        } else {
            request = ExecutorServiceCancelOnPartitionCodec.encodeRequest((String)this.uuid, (int)this.partitionId, (boolean)mayInterruptIfRunning);
            clientInvocation = new ClientInvocation(client, request, this.partitionId);
        }
        try {
            return clientInvocation.invoke();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    private void waitForRequestToBeSend() {
        ClientInvocationFuture clientCallFuture = this.getFuture();
        ClientInvocation invocation = clientCallFuture.getInvocation();
        int timeoutSeconds = 5;
        while (!invocation.isInvoked()) {
            if (timeoutSeconds-- == 0) {
                this.logger.warning("Cancel is failed because runnable/callable never send to remote !");
                break;
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }
}

